/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import mazz.i18n.Logger;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.ExtendedSQLException;

public class DbUtil {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(DbUtil.class);

    private DbUtil() {
    }

    public static Connection getConnection(String jdbc_url, String username, String password) throws SQLException {
        DatabaseTypeFactory.loadJdbcDriver(jdbc_url);
        Connection conn = username != null ? DriverManager.getConnection(jdbc_url, username, password) : DriverManager.getConnection(jdbc_url);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ping(String jdbc_url, String username, String password) {
        boolean ping;
        Connection conn = null;
        try {
            conn = DbUtil.getConnection(jdbc_url, username, password);
            ping = true;
        }
        catch (Exception e) {
            conn = null;
            ping = false;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        return ping;
    }

    public static String getSQLExceptionString(SQLException e) {
        StringBuilder str = new StringBuilder();
        do {
            if (e instanceof ExtendedSQLException) {
                str.append("SQL=[" + ((ExtendedSQLException)e).getSQL() + "]; ");
            }
            str.append("ErrorCode=[" + e.getErrorCode() + "]; ");
            str.append("SQLState=[" + e.getSQLState() + "]; ");
            str.append("Message=[" + e.getMessage() + "]; ");
            str.append("Type=[" + e.getClass().getName() + "]");
            e = e.getNextException();
            if (e == null) continue;
            str.append(" -> ");
        } while (e != null);
        return str.toString();
    }
}

