/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbsetup;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.setup.DBSetup;

public class DBSetupTask
extends Task {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private File xmlFile;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private boolean dataOnly = false;
    private boolean uninstall = false;
    private boolean exportXml = false;
    private ArrayList<Environment.Variable> sysProps = new ArrayList();
    private String table = null;
    private boolean doDelete = false;

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void setJdbcUrl(String url) {
        this.jdbcUrl = url;
    }

    public void setJdbcUser(String user) {
        this.jdbcUser = user;
    }

    public void setJdbcPassword(String pass) {
        this.jdbcPassword = pass;
    }

    public void setDataOnly(boolean data_only) {
        this.dataOnly = data_only;
    }

    public void setUninstall(boolean uninstall) {
        this.uninstall = uninstall;
    }

    public void setExportXml(boolean export) {
        this.exportXml = export;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setDelete(boolean del) {
        this.doDelete = del;
    }

    public void addSysproperty(Environment.Variable sysprop) {
        this.sysProps.add(sysprop);
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        Properties old_sysprops = new Properties();
        ArrayList<String> nonexistent_sysprops = new ArrayList<String>();
        for (Environment.Variable env_var : this.sysProps) {
            String old_value = System.setProperty(env_var.getKey(), env_var.getValue());
            if (old_value == null) {
                nonexistent_sysprops.add(env_var.getKey());
                continue;
            }
            old_sysprops.put(env_var.getKey(), old_value);
        }
        try {
            DBSetup dbs = new DBSetup(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            if (this.uninstall) {
                dbs.uninstall(this.xmlFile.getAbsolutePath());
            } else if (this.exportXml) {
                dbs.export(this.xmlFile.getAbsolutePath());
            } else if (this.table == null) {
                dbs.setup(this.xmlFile.getAbsolutePath());
            } else {
                dbs.setup(this.xmlFile.getAbsolutePath(), this.table, this.dataOnly, this.doDelete);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            for (String string : nonexistent_sysprops) {
                System.clearProperty(string);
            }
            for (Map.Entry entry : old_sysprops.entrySet()) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.xmlFile == null) {
            throw new BuildException(MSG.getMsg("Task.missing-attrib", new Object[]{this.getTaskName(), "xmlFile"}));
        }
        if (this.jdbcUrl == null) {
            throw new BuildException(MSG.getMsg("Task.missing-attrib", new Object[]{this.getTaskName(), "jdbcUrl"}));
        }
    }
}

