/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import java.sql.SQLException;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_AlterColumn
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String table = null;
    private String column = null;
    private String columnType = null;
    private String precision = null;
    private String defval = null;
    private Boolean nullable = null;
    private Boolean reindex = null;

    public void setTable(String t) {
        this.table = t;
    }

    public void setColumn(String c) {
        this.column = c;
    }

    public void setColumnType(String ct) {
        this.columnType = ct;
    }

    public void setPrecision(String p) {
        this.precision = p;
    }

    public void setNullable(String n) {
        if (n.equalsIgnoreCase("true") || n.equalsIgnoreCase("NULL")) {
            this.nullable = Boolean.TRUE;
        } else if (n.equalsIgnoreCase("false") || n.equalsIgnoreCase("NOT NULL")) {
            this.nullable = Boolean.FALSE;
        } else {
            throw new IllegalArgumentException("nullable=" + n);
        }
    }

    public void setDefault(String d) {
        this.defval = d;
    }

    public void setReindex(String r) {
        if (r.equalsIgnoreCase("true")) {
            this.reindex = Boolean.TRUE;
        } else if (r.equalsIgnoreCase("false")) {
            this.reindex = Boolean.FALSE;
        } else {
            throw new IllegalArgumentException("reindex=" + r);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (!this.isDBTargeted()) {
            return;
        }
        try {
            DatabaseType db_type = this.getDatabaseType();
            Connection conn = this.getConnection();
            this.checkColumnExistence(conn, db_type);
            db_type.alterColumn(conn, this.table, this.column, this.columnType, this.defval, this.precision, this.nullable, this.reindex);
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.altercolumn.error", new Object[]{e}), (Throwable)e);
        }
    }

    private void checkColumnExistence(Connection conn, DatabaseType db_type) throws BuildException, SQLException {
        boolean exists = db_type.checkColumnExists(conn, this.table, this.column);
        if (!exists) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.altercolumn.column-does-not-exist", new Object[]{this.table, this.column}));
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.table == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"AlterColumn", "table"}));
        }
        if (this.column == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"AlterColumn", "column"}));
        }
        if (this.columnType == null && this.nullable == null && this.defval == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"AlterColumn", "columnType|default|nullable"}));
        }
    }
}

