/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;

public class SST_JavaTask
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String className;

    public void setClassName(String className) {
        this.className = className;
    }

    public void execute() throws BuildException {
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        try {
            if (this.className.indexOf(".") == -1) {
                this.className = "org.rhq.core.db.upgrade." + this.className;
            }
            this.log(MSG.getMsg("SchemaSpecTask.javaTask.executing", new Object[]{this.className}));
            Class<?> javaTaskClass = Class.forName(this.className);
            DatabaseUpgradeTask javaTask = (DatabaseUpgradeTask)javaTaskClass.newInstance();
            DatabaseType db_type = this.getDatabaseType();
            Connection conn = this.getConnection();
            javaTask.execute(db_type, conn);
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.javaTask.error", new Object[]{e}), (Throwable)e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.className == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-child-element", new Object[]{"JavaTask", "className"}));
        }
    }
}

