/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.DBUpgrader;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;
import org.rhq.core.db.ant.dbupgrade.SchemaVersion;

public class SchemaSpec
extends Task
implements TaskContainer,
Comparable {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String versionString = null;
    private SchemaVersion version = null;
    private List<SchemaSpecTask> schemaSpecTasks = new ArrayList<SchemaSpecTask>();
    private Connection conn = null;
    private DBUpgrader upgrader = null;

    public SchemaSpec(DBUpgrader parent) {
    }

    public void setVersion(String version) {
        this.versionString = version;
    }

    public SchemaVersion getVersion() throws BuildException {
        if (this.version == null) {
            if (this.versionString == null) {
                throw new BuildException(MSG.getMsg("SchemaSpec.missing-version", new Object[0]));
            }
            try {
                this.version = new SchemaVersion(this.versionString);
            }
            catch (IllegalArgumentException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        return this.version;
    }

    public void initialize(Connection db_conn, DBUpgrader db_upgrader) {
        this.conn = db_conn;
        this.upgrader = db_upgrader;
    }

    public void addTask(Task schema_spec_task) {
        if (schema_spec_task instanceof SchemaSpecTask) {
            this.schemaSpecTasks.add((SchemaSpecTask)schema_spec_task);
        } else if (schema_spec_task instanceof UnknownElement) {
            ((UnknownElement)schema_spec_task).maybeConfigure();
            schema_spec_task = ((UnknownElement)schema_spec_task).getTask();
            if (schema_spec_task != null && schema_spec_task instanceof SchemaSpecTask) {
                this.schemaSpecTasks.add((SchemaSpecTask)schema_spec_task);
            } else {
                throw new BuildException(MSG.getMsg("SchemaSpec.cannot-add-schema-spec-task", new Object[]{schema_spec_task.getTaskName(), SchemaSpecTask.class}));
            }
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        for (SchemaSpecTask sst : this.schemaSpecTasks) {
            try {
                this.log(MSG.getMsg("SchemaSpec.executing-schema-spec-task", new Object[]{((Object)((Object)sst)).getClass(), this.getVersion()}));
                sst.initialize(this.conn, this.upgrader);
                if (sst.isIgnoreError()) {
                    try {
                        this.conn.commit();
                    }
                    catch (SQLException e) {
                        this.log("commit() exception: " + e.toString());
                    }
                }
                sst.execute();
            }
            catch (Exception e) {
                String msg = MSG.getMsg("SchemaSpec.error-executing-schema-spec-task", new Object[]{((Object)((Object)sst)).getClass().getName(), this.getVersion(), e});
                if (!sst.isIgnoreError()) {
                    throw new BuildException(msg, (Throwable)e);
                }
                try {
                    this.conn.rollback();
                }
                catch (SQLException e2) {
                    this.log("rollback() exception: " + e2.toString());
                }
                this.log(msg);
            }
        }
    }

    private void validateAttributes() throws BuildException {
        this.getVersion();
    }

    public String toString() {
        return "SchemaSpec[" + this.getVersion() + "]";
    }

    public int compareTo(Object o) {
        if (o instanceof SchemaSpec) {
            SchemaSpec ss = (SchemaSpec)o;
            return this.getVersion().compareTo(ss.getVersion());
        }
        throw new IllegalArgumentException(MSG.getMsg("SchemaSpec.cannot-compare-non-schema-spec", new Object[]{o}));
    }
}

