/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.core.db.setup.Table;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class OracleTable
extends Table {
    public OracleTable(Node node, DatabaseType dbtype, DBSetup dbsetup) throws SAXException {
        super(node, dbtype, dbsetup);
    }

    public OracleTable(ResultSet set, DatabaseMetaData meta, DBSetup dbsetup) throws SQLException {
        super(set, meta, dbsetup);
    }

    protected static List<Table> getTables(DBSetup parent, String username) throws SQLException {
        if (username != null) {
            username = username.toUpperCase();
        }
        ArrayList<Table> coll = new ArrayList<Table>();
        String[] types = new String[]{"TABLE"};
        DatabaseMetaData meta = parent.getConnection().getMetaData();
        ResultSet setTabs = meta.getTables(null, username, "%", types);
        while (setTabs.next()) {
            coll.add(new OracleTable(setTabs, meta, parent));
        }
        return coll;
    }

    @Override
    protected String getTableSpaceSyntax() {
        return " TABLESPACE ";
    }

    @Override
    protected String getParallelSyntax() {
        return " PARALLEL (DEGREE DEFAULT)";
    }

    @Override
    protected String getLoggingSyntax() {
        return " NOLOGGING";
    }

    @Override
    protected String getCacheSyntax() {
        return " CACHE";
    }

    @Override
    protected String getStorageSyntax() {
        return " STORAGE ";
    }
}

