/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;
import org.rhq.core.util.obfuscation.Obfuscator;

public abstract class AbstractConfigurationObfuscationUpgradeTask
implements DatabaseUpgradeTask {
    protected Connection connection;
    protected DatabaseType databaseType;

    protected abstract Map<Integer, Integer> getConfigurationIdConfigurationDefinitionIdPairs() throws SQLException;

    protected abstract String getEntityTypeDescription();

    @Override
    public void execute(DatabaseType type, Connection connection) throws SQLException {
        this.connection = connection;
        this.databaseType = type;
        for (Map.Entry<Integer, Integer> confAndDef : this.getConfigurationIdConfigurationDefinitionIdPairs().entrySet()) {
            List<PropertyDefinition> defs = this.getTopDefinitions(confAndDef.getValue());
            List<Property> props = this.getTopProperties(confAndDef.getKey());
            Map<PropertyDefinition, Property> pairs = this.matchDefinitionsAndProperties(defs, props);
            for (Map.Entry<PropertyDefinition, Property> entry : pairs.entrySet()) {
                try {
                    this.processProperty(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    throw new SQLException("Failed to obfuscate passwords while processing entities of type [" + this.getEntityTypeDescription() + "]. The failure happened while processing: configuration definition id: " + confAndDef.getValue() + ", configuration id: " + confAndDef.getKey() + ", property definition: " + entry.getKey() + ", property: " + entry.getValue(), e);
                }
            }
        }
    }

    private void processProperty(PropertyDefinition pd, Property p) throws Exception {
        switch (pd.type) {
            case MAP: 
            case LIST: {
                List<PropertyDefinition> childDefs = pd.getChildDefinitions();
                List<Property> childProps = p.getChildren();
                Map<PropertyDefinition, Property> pairs = this.matchDefinitionsAndProperties(childDefs, childProps);
                for (Map.Entry<PropertyDefinition, Property> entry : pairs.entrySet()) {
                    this.processProperty(entry.getKey(), entry.getValue());
                }
                break;
            }
            case SIMPLE: {
                String sql;
                if (pd.simpleType != PropertySimpleType.PASSWORD || p.type != PropertyType.SIMPLE) break;
                if (p.value != null) {
                    String obfuscatedValue = Obfuscator.encode((String)p.value);
                    sql = "UPDATE rhq_config_property SET string_value = '" + obfuscatedValue + "', dtype = 'obfuscated' WHERE id = " + p.id;
                } else {
                    sql = "UPDATE rhq_config_property SET dtype='obfuscated' WHERE id = " + p.id;
                }
                this.databaseType.executeSql(this.connection, sql);
            }
        }
    }

    private List<PropertyDefinition> getTopDefinitions(int configurationDefinitionId) throws SQLException {
        String sql = "SELECT id, name, dtype, simple_type FROM rhq_config_prop_def WHERE config_def_id = " + configurationDefinitionId;
        List<Object[]> results = this.databaseType.executeSelectSql(this.connection, sql);
        ArrayList<PropertyDefinition> ret = new ArrayList<PropertyDefinition>();
        for (Object[] row : results) {
            PropertyDefinition pd = new PropertyDefinition();
            pd.id = ((Number)row[0]).intValue();
            pd.name = (String)row[1];
            pd.type = PropertyType.fromName((String)row[2]);
            pd.simpleType = row[3] != null ? PropertySimpleType.fromName((String)row[3]) : null;
            ret.add(pd);
        }
        return ret;
    }

    private List<Property> getTopProperties(int configurationId) throws SQLException {
        String sql = "SELECT id, name, dtype, string_value FROM rhq_config_property WHERE configuration_id = " + configurationId;
        List<Object[]> results = this.databaseType.executeSelectSql(this.connection, sql);
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Object[] row : results) {
            Property p = new Property();
            p.id = ((Number)row[0]).intValue();
            p.name = (String)row[1];
            p.type = PropertyType.fromName((String)row[2]);
            p.value = (String)row[3];
            ret.add(p);
        }
        return ret;
    }

    private Map<PropertyDefinition, Property> matchDefinitionsAndProperties(List<PropertyDefinition> defs, List<Property> props) {
        class DefAndProp {
            PropertyDefinition def;
            Property prop;

            DefAndProp() {
            }
        }
        DefAndProp dap2;
        HashMap<String, DefAndProp> mapping = new HashMap<String, DefAndProp>();
        for (PropertyDefinition pd : defs) {
            dap2 = new DefAndProp();
            dap2.def = pd;
            mapping.put(pd.name, dap2);
        }
        for (Property p : props) {
            dap2 = (DefAndProp)mapping.get(p.name);
            if (dap2 == null) continue;
            dap2.prop = p;
        }
        HashMap<PropertyDefinition, Property> ret = new HashMap<PropertyDefinition, Property>();
        for (DefAndProp dap2 : mapping.values()) {
            ret.put(dap2.def, dap2.prop);
        }
        return ret;
    }

    class Property {
        int id;
        String name;
        PropertyType type;
        String value;

        Property() {
        }

        List<Property> getChildren() throws SQLException {
            if (this.type == PropertyType.SIMPLE || this.type == PropertyType.OBFUSCATED) {
                return Collections.emptyList();
            }
            String sql = "SELECT id, name, dtype, string_value FROM rhq_config_property WHERE ";
            switch (this.type) {
                case MAP: {
                    sql = sql + "parent_map_id = " + this.id;
                    break;
                }
                case LIST: {
                    sql = sql + "parent_list_id = " + this.id;
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            List<Object[]> results = AbstractConfigurationObfuscationUpgradeTask.this.databaseType.executeSelectSql(AbstractConfigurationObfuscationUpgradeTask.this.connection, sql);
            ArrayList<Property> ret = new ArrayList<Property>();
            for (Object[] row : results) {
                Property p = new Property();
                p.id = ((Number)row[0]).intValue();
                p.name = (String)row[1];
                p.type = PropertyType.fromName((String)row[2]);
                p.value = (String)row[3];
                ret.add(p);
            }
            return ret;
        }

        public String toString() {
            return "[id: " + this.id + ", name: '" + this.name + "', type: " + this.type.name() + "]";
        }
    }

    class PropertyDefinition {
        int id;
        String name;
        PropertyType type;
        PropertySimpleType simpleType;

        PropertyDefinition() {
        }

        List<PropertyDefinition> getChildDefinitions() throws SQLException {
            if (this.type == PropertyType.SIMPLE || this.type == PropertyType.OBFUSCATED) {
                return Collections.emptyList();
            }
            String sql = "SELECT id, name, dtype, simple_type FROM rhq_config_prop_def WHERE ";
            switch (this.type) {
                case MAP: {
                    sql = sql + "parent_map_definition_id = " + this.id;
                    break;
                }
                case LIST: {
                    sql = sql + "parent_list_definition_id = " + this.id;
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            List<Object[]> results = AbstractConfigurationObfuscationUpgradeTask.this.databaseType.executeSelectSql(AbstractConfigurationObfuscationUpgradeTask.this.connection, sql);
            ArrayList<PropertyDefinition> ret = new ArrayList<PropertyDefinition>();
            for (Object[] row : results) {
                PropertyDefinition pd = new PropertyDefinition();
                pd.id = ((Number)row[0]).intValue();
                pd.name = (String)row[1];
                pd.type = PropertyType.fromName((String)row[2]);
                pd.simpleType = row[3] != null ? PropertySimpleType.fromName((String)row[3]) : null;
                ret.add(pd);
            }
            return ret;
        }

        public String toString() {
            return "[id: " + this.id + ", name: '" + this.name + "', type: " + this.type.name() + "]";
        }
    }

    static enum PropertySimpleType {
        VARIOUS,
        PASSWORD;


        static PropertySimpleType fromName(String name) {
            if ("PASSWORD".equals(name)) {
                return PASSWORD;
            }
            return VARIOUS;
        }
    }

    static enum PropertyType {
        MAP,
        LIST,
        SIMPLE,
        OBFUSCATED;


        static PropertyType fromName(String name) {
            if ("map".equals(name)) {
                return MAP;
            }
            if ("list".equals(name)) {
                return LIST;
            }
            if ("property".equals(name)) {
                return SIMPLE;
            }
            if ("obfuscated".equals(name)) {
                return OBFUSCATED;
            }
            return null;
        }
    }
}

