/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import mazz.i18n.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;

public class BundleVersionOrderUpgradeTask
implements DatabaseUpgradeTask {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(BundleVersionOrderUpgradeTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DatabaseType databaseType, Connection connection) throws SQLException {
        List<Integer> bundleIds = this.getAllBundleIds(databaseType, connection);
        if (bundleIds != null && !bundleIds.isEmpty()) {
            for (Integer bundleId : bundleIds) {
                List<VersionInfo> versionInfos = this.getBundleVersions(bundleId, databaseType, connection);
                if (versionInfos == null || versionInfos.isEmpty()) continue;
                TreeMap<ComparableVersion, VersionInfo> ordered = new TreeMap<ComparableVersion, VersionInfo>();
                for (VersionInfo versionInfo : versionInfos) {
                    ComparableVersion comparableVersion = new ComparableVersion(versionInfo.version);
                    ordered.put(comparableVersion, versionInfo);
                }
                int expectedNext = 0;
                for (VersionInfo orderedBundleVersion : ordered.values()) {
                    if (orderedBundleVersion.versionOrder != expectedNext) {
                        String sql = "UPDATE RHQ_BUNDLE_VERSION SET VERSION_ORDER=" + expectedNext + " WHERE ID=" + orderedBundleVersion.id;
                        Statement s = null;
                        try {
                            LOG.debug("DatabaseType.generic-message", new Object[]{"Correcting version order for bundle version ID [" + orderedBundleVersion.id + "]"});
                            LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
                            s = connection.createStatement();
                            int rowsUpdated = s.executeUpdate(sql);
                            if (rowsUpdated != 1) {
                                LOG.error("DatabaseType.generic-error", new Object[]{"Failed to update version order for bundle version ID [" + orderedBundleVersion.id + "]. Will continue but problems may persist."});
                            }
                            databaseType.closeStatement(s);
                        }
                        catch (Throwable throwable) {
                            databaseType.closeStatement(s);
                            throw throwable;
                        }
                    }
                    ++expectedNext;
                }
            }
        } else {
            LOG.debug("DatabaseType.generic-message", new Object[]{"No bundles exist - nothing to fix."});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getAllBundleIds(DatabaseType databaseType, Connection connection) throws SQLException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Statement s = null;
        try {
            String sql = "SELECT ID FROM RHQ_BUNDLE";
            LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
            s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                int id = rs.getInt(1);
                ids.add(id);
            }
            databaseType.closeStatement(s);
        }
        catch (Throwable throwable) {
            databaseType.closeStatement(s);
            throw throwable;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VersionInfo> getBundleVersions(int bundleId, DatabaseType databaseType, Connection connection) throws SQLException {
        ArrayList<VersionInfo> infos = new ArrayList<VersionInfo>();
        Statement s = null;
        try {
            String sql = "SELECT ID, VERSION_ORDER, VERSION FROM RHQ_BUNDLE_VERSION WHERE BUNDLE_ID = " + bundleId;
            LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
            s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                VersionInfo info = new VersionInfo();
                info.id = rs.getInt(1);
                info.versionOrder = rs.getInt(2);
                info.version = rs.getString(3);
                infos.add(info);
            }
            databaseType.closeStatement(s);
        }
        catch (Throwable throwable) {
            databaseType.closeStatement(s);
            throw throwable;
        }
        return infos;
    }

    private class VersionInfo {
        int id;
        int versionOrder;
        String version;

        private VersionInfo() {
        }
    }
}

