/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import com.thoughtworks.xstream.XStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.vfs.ActiveFileSystems;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.backend.vfs.impl.PathImpl;
import org.uberfire.backend.workbench.WorkbenchServices;
import org.uberfire.client.workbench.model.PerspectiveDefinition;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class WorkbenchServicesImpl
implements WorkbenchServices {
    @Inject
    private VFSService vfsService;
    @Inject
    @Named(value="fs")
    private ActiveFileSystems fileSystems;
    @Inject
    @SessionScoped
    private Identity identity;
    private XStream xs = new XStream();
    private Path bootstrapRoot = null;

    @PostConstruct
    public void init() {
        this.bootstrapRoot = (Path)this.fileSystems.getBootstrapFileSystem().getRootDirectories().get(0);
    }

    public void save(PerspectiveDefinition perspective) {
        String xml = this.xs.toXML((Object)perspective);
        String rootURI = this.bootstrapRoot.toURI();
        this.vfsService.write((Path)new PathImpl(rootURI + "/.metadata/.users/" + this.identity.getName() + "/.perspectives/" + perspective.getName() + ".perspective"), xml);
    }

    public PerspectiveDefinition load(String perspectiveName) {
        String rootURI = this.bootstrapRoot.toURI();
        PathImpl path = new PathImpl(rootURI + "/.metadata/.users/" + this.identity.getName() + "/.perspectives/" + perspectiveName + ".perspective");
        if (this.vfsService.exists((Path)path, new LinkOption[0])) {
            String xml = this.vfsService.readAllString((Path)path);
            return (PerspectiveDefinition)this.xs.fromXML(xml);
        }
        return null;
    }
}

