/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.uberfire.commons.util.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.PathMatcher;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.UserPrincipalLookupService;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileStore;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class JGitFileSystem
implements FileSystem {
    private static final Set<String> SUPPORTED_ATTR_VIEWS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("basic");
        }
    });
    private final FileSystemProvider provider;
    private final Git gitRepo;
    private final ListBranchCommand.ListMode listMode;
    private boolean isClose = false;
    private final FileStore fileStore;
    private final String name;

    JGitFileSystem(FileSystemProvider provider, Git git, String name) {
        this(provider, git, name, null);
    }

    JGitFileSystem(FileSystemProvider provider, Git git, String name, ListBranchCommand.ListMode listMode) {
        this.provider = (FileSystemProvider)Preconditions.checkNotNull((String)"provider", (Object)provider);
        this.gitRepo = (Git)Preconditions.checkNotNull((String)"git", (Object)git);
        this.name = Preconditions.checkNotEmpty((String)"name", (String)name);
        this.listMode = listMode;
        this.fileStore = new JGitFileStore(this.gitRepo.getRepository());
    }

    public String getName() {
        return this.name;
    }

    public Git gitRepo() {
        return this.gitRepo;
    }

    public FileSystemProvider provider() {
        return this.provider;
    }

    public boolean isOpen() {
        return !this.isClose;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getSeparator() {
        return "/";
    }

    public Iterable<Path> getRootDirectories() {
        this.checkClose();
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return new Iterator<Path>(){
                    Iterator<Ref> branches = null;

                    @Override
                    public boolean hasNext() {
                        if (this.branches == null) {
                            this.init();
                        }
                        return this.branches.hasNext();
                    }

                    private void init() {
                        this.branches = JGitUtil.branchList(JGitFileSystem.this.gitRepo, JGitFileSystem.this.listMode).iterator();
                    }

                    @Override
                    public Path next() {
                        if (this.branches == null) {
                            this.init();
                        }
                        return JGitPathImpl.createRoot(JGitFileSystem.this, "/", Repository.shortenRefName((String)this.branches.next().getName()) + "@" + JGitFileSystem.this.name, false);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<FileStore> getFileStores() {
        this.checkClose();
        return new Iterable<FileStore>(){

            @Override
            public Iterator<FileStore> iterator() {
                return new Iterator<FileStore>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < 1;
                    }

                    @Override
                    public FileStore next() {
                        if (this.i < 1) {
                            ++this.i;
                            return JGitFileSystem.this.fileStore;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Set<String> supportedFileAttributeViews() {
        this.checkClose();
        return SUPPORTED_ATTR_VIEWS;
    }

    public Path getPath(String first, String ... more) throws InvalidPathException {
        this.checkClose();
        Preconditions.checkNotEmpty((String)"first", (String)first);
        if (more == null || more.length == 0) {
            return JGitPathImpl.create(this, first, "master@" + this.name, false);
        }
        StringBuilder sb = new StringBuilder();
        for (String segment : more) {
            if (segment.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(this.getSeparator());
            }
            sb.append(segment);
        }
        return JGitPathImpl.create(this, sb.toString(), first + "@" + this.name, false);
    }

    public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
        this.checkClose();
        Preconditions.checkNotEmpty((String)"syntaxAndPattern", (String)syntaxAndPattern);
        throw new UnsupportedOperationException();
    }

    public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
        this.checkClose();
        throw new UnsupportedOperationException();
    }

    public WatchService newWatchService() throws UnsupportedOperationException, IOException {
        this.checkClose();
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.checkClose();
        this.gitRepo.getRepository().close();
        this.isClose = true;
    }

    private void checkClose() throws IllegalStateException {
        if (this.isClose) {
            throw new IllegalStateException("FileSystem is close.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JGitFileSystem that = (JGitFileSystem)o;
        if (this.isClose != that.isClose) {
            return false;
        }
        if (this.fileStore != null ? !this.fileStore.equals(that.fileStore) : that.fileStore != null) {
            return false;
        }
        if (!this.gitRepo.equals(that.gitRepo)) {
            return false;
        }
        if (this.listMode != that.listMode) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.provider.equals(that.provider);
    }

    public int hashCode() {
        int result = this.provider.hashCode();
        result = 31 * result + this.gitRepo.hashCode();
        result = 31 * result + (this.listMode != null ? this.listMode.hashCode() : 0);
        result = 31 * result + (this.isClose ? 1 : 0);
        result = 31 * result + (this.fileStore != null ? this.fileStore.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

