/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import javax.servlet.http.Cookie;
import org.uberfire.commons.util.PreconditionsServer;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticatedStorageProvider;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.crypt.CryptProvider;
import org.uberfire.security.server.HttpSecurityContext;
import org.uberfire.security.server.crypt.DefaultCryptProvider;

public class CookieStorage
implements AuthenticatedStorageProvider {
    private static final int DEFAULT_EXPIRE_48_HOURS = 172800;
    private static final String EMPTY = "__empty__";
    private static final CryptProvider CRYPT_PROVIDER = new DefaultCryptProvider();
    private String cookieName = "uf.inf";

    public CookieStorage() {
        this(null);
    }

    public CookieStorage(String cookieName) {
        if (cookieName != null && !cookieName.isEmpty()) {
            this.cookieName = cookieName;
        }
    }

    public void store(SecurityContext context, Subject subject) {
        HttpSecurityContext httpContext = (HttpSecurityContext)PreconditionsServer.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        String content = CRYPT_PROVIDER.encrypt(subject.getName(), null);
        Cookie securityCookie = new Cookie(this.cookieName, content);
        securityCookie.setPath("/");
        securityCookie.setMaxAge(172800);
        httpContext.getResponse().addCookie(securityCookie);
    }

    public void cleanup(SecurityContext context) {
        HttpSecurityContext httpContext = (HttpSecurityContext)PreconditionsServer.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        Cookie securityCookie = new Cookie(this.cookieName, EMPTY);
        securityCookie.setPath("/");
        securityCookie.setMaxAge(0);
        httpContext.getResponse().addCookie(securityCookie);
    }

    public Principal load(SecurityContext context) {
        HttpSecurityContext httpContext = (HttpSecurityContext)PreconditionsServer.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        String originalCookieValue = this.getCookieValue(this.cookieName, null, httpContext.getRequest().getCookies());
        if (originalCookieValue == null) {
            return null;
        }
        final String userId = CRYPT_PROVIDER.decrypt(originalCookieValue, null);
        if (userId == null) {
            return null;
        }
        return new Principal(){

            public String getName() {
                return userId;
            }
        };
    }

    private String getCookieValue(String cookieName, String defaultValue, Cookie ... cookies) {
        if (cookies == null || cookies.length == 0) {
            return defaultValue;
        }
        for (Cookie cookie : cookies) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return defaultValue;
    }
}

