/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.http.websocketx.server.WebSocketServerPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class WebSocketServer {
    private final int port;

    public WebSocketServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new WebSocketServerPipelineFactory());
        bootstrap.bind(new InetSocketAddress(this.port));
        System.out.println("Web socket server started at port " + this.port + '.');
        System.out.println("Open your browser and navigate to http://localhost:" + this.port + '/');
    }

    public static void main(String[] args) {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new WebSocketServer(port).run();
    }
}

