/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.AbstractChannelSink;
import io.netty.channel.Channel;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelState;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.channel.socket.nio.NioAcceptedSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.nio.NioWorker;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.internal.DeadLockProofWorker;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

class NioServerSocketPipelineSink
extends AbstractChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketPipelineSink.class);
    private final NioWorker[] workers;
    private final AtomicInteger workerIndex = new AtomicInteger();

    NioServerSocketPipelineSink(Executor workerExecutor, int workerCount) {
        this.workers = new NioWorker[workerCount];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new NioWorker(workerExecutor);
        }
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            this.handleAcceptedSocket(e);
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                this.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (SocketAddress)value);
                    break;
                }
                this.close(channel, future);
            }
        }
    }

    private void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(NioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            channel.socket.socket().bind(localAddress, channel.getConfig().getBacklog());
            bound = true;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
            Executor bossExecutor = ((NioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
            DeadLockProofWorker.start(bossExecutor, new Boss(channel));
            bossStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
        finally {
            if (!bossStarted && bound) {
                this.close(channel, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(NioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            if (channel.socket.isOpen()) {
                channel.socket.close();
                Selector selector = channel.selector;
                if (selector != null) {
                    selector.wakeup();
                }
            }
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound(channel);
                    }
                    Channels.fireChannelClosed(channel);
                } else {
                    future.setSuccess();
                }
            }
            finally {
                channel.shutdownLock.unlock();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    NioWorker nextWorker() {
        return this.workers[Math.abs(this.workerIndex.getAndIncrement() % this.workers.length)];
    }

    private final class Boss
    implements Runnable {
        private final Selector selector;
        private final NioServerSocketChannel channel;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Boss(NioServerSocketChannel channel) throws IOException {
            this.channel = channel;
            this.selector = Selector.open();
            boolean registered = false;
            try {
                channel.socket.register(this.selector, 16);
                registered = true;
            }
            finally {
                if (!registered) {
                    this.closeSelector();
                }
            }
            channel.selector = this.selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                Thread currentThread = Thread.currentThread();
                this.channel.shutdownLock.lock();
                block11: while (true) {
                    while (true) {
                        try {
                            while (true) {
                                SocketChannel acceptedSocket;
                                if (this.selector.select(1000L) > 0) {
                                    this.selector.selectedKeys().clear();
                                }
                                if ((acceptedSocket = this.channel.socket.accept()) == null) continue;
                                this.registerAcceptedChannel(acceptedSocket, currentThread);
                            }
                        }
                        catch (SocketTimeoutException e) {
                            continue;
                        }
                        catch (CancelledKeyException e) {
                            continue;
                        }
                        catch (ClosedSelectorException e) {
                            continue;
                        }
                        catch (ClosedChannelException e) {
                            break block16;
                        }
                        catch (Throwable e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("Failed to accept a connection.", e);
                            }
                            try {
                                Thread.sleep(1000L);
                                continue block11;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                finally {
                    this.channel.shutdownLock.unlock();
                    this.closeSelector();
                }
            }
        }

        private void registerAcceptedChannel(SocketChannel acceptedSocket, Thread currentThread) {
            block5: {
                try {
                    ChannelPipeline pipeline = this.channel.getConfig().getPipelineFactory().getPipeline();
                    NioWorker worker = NioServerSocketPipelineSink.this.nextWorker();
                    worker.register(NioAcceptedSocketChannel.create(this.channel.getFactory(), pipeline, this.channel, NioServerSocketPipelineSink.this, acceptedSocket, worker, currentThread), null);
                }
                catch (Exception e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Failed to initialize an accepted socket.", e);
                    }
                    try {
                        acceptedSocket.close();
                    }
                    catch (IOException e2) {
                        if (!logger.isWarnEnabled()) break block5;
                        logger.warn("Failed to close a partially accepted socket.", e2);
                    }
                }
            }
        }

        private void closeSelector() {
            block2: {
                this.channel.selector = null;
                try {
                    this.selector.close();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn("Failed to close a selector.", e);
                }
            }
        }
    }
}

