/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.FileSystemFactory;
import org.uberfire.backend.vfs.PathFactory;

@ApplicationScoped
public class Paths {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private Map<org.kie.commons.java.nio.file.FileSystem, FileSystem> cache = new HashMap<org.kie.commons.java.nio.file.FileSystem, FileSystem>();

    public org.uberfire.backend.vfs.Path convert(Path path) {
        if (path == null) {
            return null;
        }
        Map attributes = this.ioService.readAttributes(path, "basic:isRegularFile,isDirectory,size,lastModifiedTime,creationTime");
        if (path.getFileName() == null) {
            return PathFactory.newPath((FileSystem)this.convert(path.getFileSystem()), (String)"/", (String)path.toUri().toString(), (Map)attributes);
        }
        return PathFactory.newPath((FileSystem)this.convert(path.getFileSystem()), (String)path.getFileName().toString(), (String)path.toUri().toString(), (Map)attributes);
    }

    public Path convert(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return null;
        }
        try {
            return this.ioService.get(URI.create(path.toURI()));
        }
        catch (IllegalArgumentException e) {
            try {
                return this.ioService.get(URI.create(URIUtil.encodePath((String)path.toURI())));
            }
            catch (URIException ex) {
                return null;
            }
        }
    }

    public FileSystem convert(org.kie.commons.java.nio.file.FileSystem fs) {
        if (!this.cache.containsKey(fs)) {
            HashMap<String, String> roots = new HashMap<String, String>();
            for (Path root : fs.getRootDirectories()) {
                roots.put(root.toUri().toString(), root.getFileName() == null ? "/" : root.getFileName().toString());
            }
            this.cache.put(fs, FileSystemFactory.newFS(roots, (Set)fs.supportedFileAttributeViews()));
        }
        return this.cache.get(fs);
    }
}

