/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.qotm;

import io.netty.bootstrap.ConnectionlessBootstrap;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.channel.FixedReceiveBufferSizePredictorFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannelFactory;
import io.netty.example.qotm.QuoteOfTheMomentClientHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class QuoteOfTheMomentClient {
    private final int port;

    public QuoteOfTheMomentClient(int port) {
        this.port = port;
    }

    public void run() {
        NioDatagramChannelFactory f = new NioDatagramChannelFactory(Executors.newCachedThreadPool());
        ConnectionlessBootstrap b = new ConnectionlessBootstrap(f);
        b.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(new StringEncoder(CharsetUtil.ISO_8859_1), new StringDecoder(CharsetUtil.ISO_8859_1), new QuoteOfTheMomentClientHandler());
            }
        });
        b.setOption("broadcast", "true");
        b.setOption("receiveBufferSizePredictorFactory", new FixedReceiveBufferSizePredictorFactory(1024));
        DatagramChannel c = (DatagramChannel)b.bind(new InetSocketAddress(0));
        c.write("QOTM?", new InetSocketAddress("255.255.255.255", this.port));
        if (!c.getCloseFuture().awaitUninterruptibly(5000L)) {
            System.err.println("QOTM request timed out.");
            c.close().awaitUninterruptibly();
        }
        f.releaseExternalResources();
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new QuoteOfTheMomentClient(port).run();
    }
}

