/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "ms" locale.
 */
public class LocalizedNamesImpl_ms extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "MY",
        "ID",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "NL",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "TD",
        "CV",
        "KY",
        "EA",
        "CN",
        "CX",
        "CL",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CK",
        "CI",
        "HR",
        "CU",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "AE",
        "GQ",
        "ER",
        "EE",
        "ET",
        "FK",
        "FO",
        "PT",
        "FJ",
        "PH",
        "FI",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "DE",
        "JE",
        "DJ",
        "JO",
        "CM",
        "CA",
        "KZ",
        "KH",
        "KE",
        "AX",
        "IC",
        "MH",
        "SB",
        "EU",
        "CY",
        "KI",
        "CR",
        "KW",
        "KG",
        "LA",
        "LV",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LB",
        "LU",
        "MO",
        "MK",
        "MG",
        "MA",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "EG",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "NF",
        "MP",
        "NO",
        "QO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "FR",
        "PE",
        "PN",
        "PL",
        "PR",
        "AC",
        "CP",
        "QA",
        "CF",
        "CZ",
        "DO",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "KR",
        "SN",
        "ES",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "GS",
        "LK",
        "SS",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "GB",
        "UM",
        "UY",
        "KP",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "GR",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunia");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amerika Utara");
    namesMap.put("005", "Amerika Selatan");
    namesMap.put("011", "Afrika Barat");
    namesMap.put("013", "Amerika Tengah");
    namesMap.put("014", "Afrika Timur");
    namesMap.put("015", "Afrika Utara");
    namesMap.put("017", "Afrika Tengah");
    namesMap.put("018", "Selatan Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Utara Amerika");
    namesMap.put("030", "Asia Timur");
    namesMap.put("034", "Asia Selatan");
    namesMap.put("035", "Asia Tenggara");
    namesMap.put("039", "Eropah Selatan");
    namesMap.put("053", "Australia dan New Zealand");
    namesMap.put("057", "Wilayah Mikronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Tengah");
    namesMap.put("145", "Asia Barat");
    namesMap.put("150", "Eropah");
    namesMap.put("151", "Eropah Timur");
    namesMap.put("154", "Eropah Utara");
    namesMap.put("155", "Eropah Barat");
    namesMap.put("419", "Amerika Latin");
    namesMap.put("AC", "Pulau Ascension");
    namesMap.put("AE", "Emiriah Arab Bersatu");
    namesMap.put("AG", "Antigua dan Barbuda");
    namesMap.put("AX", "Kepulauan Åland");
    namesMap.put("BA", "Bosnia dan Herzegovina");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Congo - Kinshasa");
    namesMap.put("CF", "Republik Afrika Tengah");
    namesMap.put("CG", "Congo");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CP", "Pulau Clipperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CS", "Serbia dan Montenegro");
    namesMap.put("CY", "Kibris");
    namesMap.put("CZ", "Republik Czech");
    namesMap.put("DE", "Jerman");
    namesMap.put("DJ", "Jibouti");
    namesMap.put("DO", "Republik Dominican");
    namesMap.put("DZ", "Aljazair");
    namesMap.put("EA", "Ceuta dan Melilla");
    namesMap.put("EG", "Mesir");
    namesMap.put("EH", "Sahara Barat");
    namesMap.put("ES", "Sepanyol");
    namesMap.put("EU", "Kesatuan Eropah");
    namesMap.put("FK", "Falkland Islands");
    namesMap.put("FR", "Perancis");
    namesMap.put("GR", "Yunani");
    namesMap.put("GW", "Guinea Bissau");
    namesMap.put("HU", "Hungari");
    namesMap.put("IC", "Kepulauan Canary");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JP", "Jepun");
    namesMap.put("KH", "Kemboja");
    namesMap.put("KN", "Saint Kitts dan Nevis");
    namesMap.put("KP", "Utara Korea");
    namesMap.put("KR", "Selatan Korea");
    namesMap.put("LB", "Lubnan");
    namesMap.put("LU", "Luksembourg");
    namesMap.put("MA", "Maghribi");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Kepulauan Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MV", "Maldiv");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NL", "Belanda");
    namesMap.put("PH", "Filipina");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinian Territory");
    namesMap.put("PT", "Feringgi");
    namesMap.put("QO", "Oceania Terpencil");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arab Saudi");
    namesMap.put("SB", "Kepulauan Solomon");
    namesMap.put("SG", "Singapura");
    namesMap.put("SL", "Siera Leon");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tome dan Principe");
    namesMap.put("TD", "Cad");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad dan Tobago");
    namesMap.put("UM", "United States Minor Outlying Islands");
    namesMap.put("US", "Amerika Syarikat");
    namesMap.put("VA", "Vatican");
    namesMap.put("VC", "Saint Vincent dan Grenadines");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Afrika Selatan");
    namesMap.put("ZZ", "Wilayah Tidak Diketahui");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunia",
        "002": "Afrika",
        "003": "Amerika Utara",
        "005": "Amerika Selatan",
        "011": "Afrika Barat",
        "013": "Amerika Tengah",
        "014": "Afrika Timur",
        "015": "Afrika Utara",
        "017": "Afrika Tengah",
        "018": "Selatan Afrika",
        "019": "Amerika",
        "021": "Utara Amerika",
        "030": "Asia Timur",
        "034": "Asia Selatan",
        "035": "Asia Tenggara",
        "039": "Eropah Selatan",
        "053": "Australia dan New Zealand",
        "057": "Wilayah Mikronesia",
        "061": "Polinesia",
        "143": "Asia Tengah",
        "145": "Asia Barat",
        "150": "Eropah",
        "151": "Eropah Timur",
        "154": "Eropah Utara",
        "155": "Eropah Barat",
        "419": "Amerika Latin",
        "AC": "Pulau Ascension",
        "AE": "Emiriah Arab Bersatu",
        "AG": "Antigua dan Barbuda",
        "AX": "Kepulauan Åland",
        "BA": "Bosnia dan Herzegovina",
        "CA": "Kanada",
        "CD": "Congo - Kinshasa",
        "CF": "Republik Afrika Tengah",
        "CG": "Congo",
        "CL": "Cile",
        "CM": "Kamerun",
        "CP": "Pulau Clipperton",
        "CR": "Kosta Rika",
        "CS": "Serbia dan Montenegro",
        "CY": "Kibris",
        "CZ": "Republik Czech",
        "DE": "Jerman",
        "DJ": "Jibouti",
        "DO": "Republik Dominican",
        "DZ": "Aljazair",
        "EA": "Ceuta dan Melilla",
        "EG": "Mesir",
        "EH": "Sahara Barat",
        "ES": "Sepanyol",
        "EU": "Kesatuan Eropah",
        "FK": "Falkland Islands",
        "FR": "Perancis",
        "GR": "Yunani",
        "GW": "Guinea Bissau",
        "HU": "Hungari",
        "IC": "Kepulauan Canary",
        "IT": "Itali",
        "JM": "Jamaika",
        "JP": "Jepun",
        "KH": "Kemboja",
        "KN": "Saint Kitts dan Nevis",
        "KP": "Utara Korea",
        "KR": "Selatan Korea",
        "LB": "Lubnan",
        "LU": "Luksembourg",
        "MA": "Maghribi",
        "MG": "Madagaskar",
        "MH": "Kepulauan Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MV": "Maldiv",
        "MX": "Meksiko",
        "MZ": "Mozambik",
        "NL": "Belanda",
        "PH": "Filipina",
        "PN": "Pitcairn",
        "PS": "Palestinian Territory",
        "PT": "Feringgi",
        "QO": "Oceania Terpencil",
        "RU": "Rusia",
        "SA": "Arab Saudi",
        "SB": "Kepulauan Solomon",
        "SG": "Singapura",
        "SL": "Siera Leon",
        "SR": "Surinam",
        "ST": "Sao Tome dan Principe",
        "TD": "Cad",
        "TJ": "Tadjikistan",
        "TR": "Turki",
        "TT": "Trinidad dan Tobago",
        "UM": "United States Minor Outlying Islands",
        "US": "Amerika Syarikat",
        "VA": "Vatican",
        "VC": "Saint Vincent dan Grenadines",
        "YE": "Yaman",
        "ZA": "Afrika Selatan",
        "ZZ": "Wilayah Tidak Diketahui"
    };
  }-*/;
}
