/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.repositories.git;

import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.commons.validation.Preconditions;
import org.uberfire.backend.repositories.Repository;

@Portable
public class LocalGitRepository
implements Repository {
    private String alias;
    private Map<String, Object> environment = new HashMap<String, Object>();
    public static final String SCHEME = "git";

    public LocalGitRepository() {
    }

    public LocalGitRepository(String alias) {
        Preconditions.checkNotNull((String)"alias", (Object)alias);
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getScheme() {
        return SCHEME;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public void addEnvironmentParameter(String key, Object value) {
        Preconditions.checkNotNull((String)"key", (Object)key);
        Preconditions.checkNotNull((String)"value", (Object)value);
        this.environment.put(key, value);
    }

    public String getUri() {
        return this.getScheme() + "://" + this.getAlias();
    }

    public boolean isValid() {
        Object username = this.environment.get("username");
        Object password = this.environment.get("password");
        return this.alias != null && username != null && password != null;
    }
}

