/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;

public class UpstreamMessageEvent
implements MessageEvent {
    private final Channel channel;
    private final Object message;
    private final SocketAddress remoteAddress;

    public UpstreamMessageEvent(Channel channel, Object message, SocketAddress remoteAddress) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.channel = channel;
        this.message = message;
        this.remoteAddress = remoteAddress != null ? remoteAddress : channel.getRemoteAddress();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        if (this.getRemoteAddress() == this.getChannel().getRemoteAddress()) {
            return this.getChannel().toString() + " RECEIVED: " + StringUtil.stripControlCharacters(this.getMessage());
        }
        return this.getChannel().toString() + " RECEIVED: " + StringUtil.stripControlCharacters(this.getMessage()) + " from " + this.getRemoteAddress();
    }
}

