/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.frame.CorruptedFrameException;
import io.netty.handler.codec.frame.FrameDecoder;
import java.math.BigInteger;

public class BigIntegerDecoder
extends FrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 5) {
            return null;
        }
        buffer.markReaderIndex();
        short magicNumber = buffer.readUnsignedByte();
        if (magicNumber != 70) {
            buffer.resetReaderIndex();
            throw new CorruptedFrameException("Invalid magic number: " + magicNumber);
        }
        int dataLength = buffer.readInt();
        if (buffer.readableBytes() < dataLength) {
            buffer.resetReaderIndex();
            return null;
        }
        byte[] decoded = new byte[dataLength];
        buffer.readBytes(decoded);
        return new BigInteger(decoded);
    }
}

