/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.bytes;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.oneone.OneToOneDecoder;

public class ByteArrayDecoder
extends OneToOneDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        byte[] array;
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer buf = (ChannelBuffer)msg;
        if (buf.hasArray()) {
            if (buf.arrayOffset() == 0 && buf.readableBytes() == buf.capacity()) {
                array = buf.array();
            } else {
                array = new byte[buf.readableBytes()];
                buf.getBytes(0, array);
            }
        } else {
            array = new byte[buf.readableBytes()];
            buf.getBytes(0, array);
        }
        return array;
    }
}

