/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelHandler;
import io.netty.handler.codec.embedder.EncoderEmbedder;
import io.netty.handler.codec.http.DefaultHttpChunk;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.internal.QueueFactory;
import java.util.Queue;

public abstract class HttpContentEncoder
extends SimpleChannelHandler {
    private final Queue<String> acceptEncodingQueue = QueueFactory.createQueue(String.class);
    private volatile EncoderEmbedder<ChannelBuffer> encoder;

    protected HttpContentEncoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (!(msg instanceof HttpMessage)) {
            ctx.sendUpstream(e);
            return;
        }
        HttpMessage m = (HttpMessage)msg;
        String acceptedEncoding = m.getHeader("Accept-Encoding");
        if (acceptedEncoding == null) {
            acceptedEncoding = "identity";
        }
        boolean offered = this.acceptEncodingQueue.offer(acceptedEncoding);
        assert (offered);
        ctx.sendUpstream(e);
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            ctx.sendDownstream(e);
        } else if (msg instanceof HttpMessage) {
            boolean hasContent;
            HttpMessage m = (HttpMessage)msg;
            this.encoder = null;
            String acceptEncoding = this.acceptEncodingQueue.poll();
            if (acceptEncoding == null) {
                throw new IllegalStateException("cannot send more responses than requests");
            }
            boolean bl = hasContent = m.isChunked() || m.getContent().readable();
            if (!hasContent) {
                ctx.sendDownstream(e);
                return;
            }
            Result result = this.beginEncode(m, acceptEncoding);
            if (result == null) {
                ctx.sendDownstream(e);
                return;
            }
            this.encoder = result.getContentEncoder();
            m.setHeader("Content-Encoding", result.getTargetContentEncoding());
            if (!m.isChunked()) {
                ChannelBuffer content = m.getContent();
                content = ChannelBuffers.wrappedBuffer(this.encode(content), this.finishEncode());
                m.setContent(content);
                if (m.containsHeader("Content-Length")) {
                    m.setHeader("Content-Length", Integer.toString(content.readableBytes()));
                }
            }
            ctx.sendDownstream(e);
        } else if (msg instanceof HttpChunk) {
            HttpChunk c = (HttpChunk)msg;
            ChannelBuffer content = c.getContent();
            if (this.encoder != null) {
                if (!c.isLast()) {
                    if ((content = this.encode(content)).readable()) {
                        c.setContent(content);
                        ctx.sendDownstream(e);
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishEncode();
                    if (lastProduct.readable()) {
                        Channels.write(ctx, Channels.succeededFuture(e.getChannel()), new DefaultHttpChunk(lastProduct), e.getRemoteAddress());
                    }
                    ctx.sendDownstream(e);
                }
            } else {
                ctx.sendDownstream(e);
            }
        } else {
            ctx.sendDownstream(e);
        }
    }

    protected abstract Result beginEncode(HttpMessage var1, String var2) throws Exception;

    private ChannelBuffer encode(ChannelBuffer buf) {
        this.encoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()]));
    }

    private ChannelBuffer finishEncode() {
        ChannelBuffer result = this.encoder.finish() ? ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.encoder = null;
        return result;
    }

    public static final class Result {
        private final String targetContentEncoding;
        private final EncoderEmbedder<ChannelBuffer> contentEncoder;

        public Result(String targetContentEncoding, EncoderEmbedder<ChannelBuffer> contentEncoder) {
            if (targetContentEncoding == null) {
                throw new NullPointerException("targetContentEncoding");
            }
            if (contentEncoder == null) {
                throw new NullPointerException("contentEncoder");
            }
            this.targetContentEncoding = targetContentEncoding;
            this.contentEncoder = contentEncoder;
        }

        public String getTargetContentEncoding() {
            return this.targetContentEncoding;
        }

        public EncoderEmbedder<ChannelBuffer> getContentEncoder() {
            return this.contentEncoder;
        }
    }
}

