/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kie.commons.validation.PortablePreconditions;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationProvider;
import org.uberfire.security.auth.AuthenticationResult;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.AuthenticationStatus;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.impl.auth.UserNameCredential;

public class DefaultAuthenticationProvider
implements AuthenticationProvider {
    private final AuthenticationSource authenticationSource;

    public DefaultAuthenticationProvider(AuthenticationSource authSource) {
        this.authenticationSource = (AuthenticationSource)PortablePreconditions.checkNotNull((String)"authSource", (Object)authSource);
    }

    public void initialize(Map<String, ?> options) {
        this.authenticationSource.initialize(options);
    }

    public boolean supportsCredential(Credential credential) {
        return this.authenticationSource.supportsCredential(credential);
    }

    public AuthenticationResult authenticate(Credential credential) throws AuthenticationException {
        if (!this.supportsCredential(credential)) {
            return new AuthenticationResult(){

                public List<String> getMessages() {
                    return new ArrayList<String>(1){
                        {
                            this.add("Credential not supported by " + DefaultAuthenticationProvider.class.getName());
                        }
                    };
                }

                public AuthenticationStatus getStatus() {
                    return AuthenticationStatus.NONE;
                }

                public Principal getPrincipal() {
                    return null;
                }
            };
        }
        final UserNameCredential realCredential = (UserNameCredential)UserNameCredential.class.cast(credential);
        if (!this.authenticationSource.authenticate((Credential)realCredential)) {
            return new AuthenticationResult(){

                public List<String> getMessages() {
                    return new ArrayList<String>(1){
                        {
                            this.add("Invalid credentials.");
                        }
                    };
                }

                public AuthenticationStatus getStatus() {
                    return AuthenticationStatus.FAILED;
                }

                public Principal getPrincipal() {
                    return null;
                }
            };
        }
        return new AuthenticationResult(){

            public List<String> getMessages() {
                return Collections.emptyList();
            }

            public AuthenticationStatus getStatus() {
                return AuthenticationStatus.SUCCESS;
            }

            public Principal getPrincipal() {
                return new Principal(){

                    public String getName() {
                        return realCredential.getUserName();
                    }
                };
            }
        };
    }
}

