/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.cdi;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import org.uberfire.security.Identity;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.impl.IdentityImpl;

public class SecurityFactory {
    private static final ThreadLocal<Subject> subjects = new ThreadLocal();
    private static AuthorizationManager authzManager = null;

    public static void setSubject(Subject subject) {
        subjects.set(subject);
    }

    public static void setAuthzManager(AuthorizationManager authzManager) {
        SecurityFactory.authzManager = authzManager;
    }

    @Produces
    @RequestScoped
    public static Identity getIdentity() {
        return new IdentityImpl(subjects.get().getName(), subjects.get().getRoles());
    }

    @Produces
    @ApplicationScoped
    public static AuthorizationManager getAuthzManager() {
        return authzManager;
    }
}

