/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

public class TokenizeLanguage
implements Language,
IsSingleton {
    private String token;
    private String headerName;
    private boolean regex;

    public static Expression tokenize(String token) {
        return TokenizeLanguage.tokenize(token, false);
    }

    public static Expression tokenize(String token, boolean regex) {
        TokenizeLanguage langugage = new TokenizeLanguage();
        langugage.setToken(token);
        langugage.setRegex(regex);
        return langugage.createExpression(null);
    }

    public static Expression tokenize(String headerName, String token) {
        return TokenizeLanguage.tokenize(headerName, token, false);
    }

    public static Expression tokenize(String headerName, String token, boolean regex) {
        TokenizeLanguage langugage = new TokenizeLanguage();
        langugage.setHeaderName(headerName);
        langugage.setToken(token);
        langugage.setRegex(regex);
        return langugage.createExpression(null);
    }

    public Predicate createPredicate(String expression) {
        return PredicateBuilder.toPredicate(this.createExpression(expression));
    }

    public Expression createExpression() {
        Expression exp;
        ObjectHelper.notNull(this.token, "token");
        Expression expression = exp = this.headerName == null ? ExpressionBuilder.bodyExpression() : ExpressionBuilder.headerExpression(this.headerName);
        if (this.regex) {
            return ExpressionBuilder.regexTokenizeExpression(exp, this.token);
        }
        return ExpressionBuilder.tokenizeExpression(exp, this.token);
    }

    public Expression createExpression(String expression) {
        if (ObjectHelper.isNotEmpty(expression)) {
            this.token = expression;
        }
        return this.createExpression();
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public boolean isSingleton() {
        return false;
    }
}

