/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.CamelContextHelper;

@XmlRootElement(name="redeliveryPolicy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RedeliveryPolicyDefinition {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private Integer maximumRedeliveries;
    @XmlAttribute
    private Long redeliveryDelay;
    @XmlAttribute
    private Boolean asyncDelayedRedelivery;
    @XmlAttribute
    private Double backOffMultiplier;
    @XmlAttribute
    private Boolean useExponentialBackOff;
    @XmlAttribute
    private Double collisionAvoidanceFactor;
    @XmlAttribute
    private Boolean useCollisionAvoidance;
    @XmlAttribute
    private Long maximumRedeliveryDelay;
    @XmlAttribute
    private LoggingLevel retriesExhaustedLogLevel;
    @XmlAttribute
    private LoggingLevel retryAttemptedLogLevel;
    @XmlAttribute
    private Boolean logRetryAttempted;
    @XmlAttribute
    private Boolean logStackTrace;
    @XmlAttribute
    private Boolean logRetryStackTrace;
    @XmlAttribute
    private Boolean logHandled;
    @XmlAttribute
    private Boolean logContinued;
    @XmlAttribute
    private Boolean logExhausted;
    @XmlAttribute
    private Boolean disableRedelivery;
    @XmlAttribute
    private String delayPattern;

    public RedeliveryPolicy createRedeliveryPolicy(CamelContext context, RedeliveryPolicy parentPolicy) {
        if (this.ref != null) {
            return CamelContextHelper.mandatoryLookup(context, this.ref, RedeliveryPolicy.class);
        }
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        if (this.maximumRedeliveries != null) {
            answer.setMaximumRedeliveries(this.maximumRedeliveries);
        }
        if (this.redeliveryDelay != null) {
            answer.setRedeliveryDelay(this.redeliveryDelay);
        }
        if (this.asyncDelayedRedelivery != null && this.asyncDelayedRedelivery.booleanValue()) {
            answer.asyncDelayedRedelivery();
        }
        if (this.retriesExhaustedLogLevel != null) {
            answer.setRetriesExhaustedLogLevel(this.retriesExhaustedLogLevel);
        }
        if (this.retryAttemptedLogLevel != null) {
            answer.setRetryAttemptedLogLevel(this.retryAttemptedLogLevel);
        }
        if (this.backOffMultiplier != null) {
            answer.setBackOffMultiplier(this.backOffMultiplier);
        }
        if (this.useExponentialBackOff != null) {
            answer.setUseExponentialBackOff(this.useExponentialBackOff);
        }
        if (this.collisionAvoidanceFactor != null) {
            answer.setCollisionAvoidanceFactor(this.collisionAvoidanceFactor);
        }
        if (this.useCollisionAvoidance != null) {
            answer.setUseCollisionAvoidance(this.useCollisionAvoidance);
        }
        if (this.maximumRedeliveryDelay != null) {
            answer.setMaximumRedeliveryDelay(this.maximumRedeliveryDelay);
        }
        if (this.logStackTrace != null) {
            answer.setLogStackTrace(this.logStackTrace);
        }
        if (this.logRetryStackTrace != null) {
            answer.setLogRetryStackTrace(this.logRetryStackTrace);
        }
        if (this.logHandled != null) {
            answer.setLogHandled(this.logHandled);
        }
        if (this.logContinued != null) {
            answer.setLogContinued(this.logContinued);
        }
        if (this.logRetryAttempted != null) {
            answer.setLogRetryAttempted(this.logRetryAttempted);
        }
        if (this.logExhausted != null) {
            answer.setLogExhausted(this.logExhausted);
        }
        if (this.disableRedelivery != null && this.disableRedelivery.booleanValue()) {
            answer.setMaximumRedeliveries(0);
        }
        if (this.delayPattern != null) {
            answer.setDelayPattern(this.delayPattern);
        }
        return answer;
    }

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries: " + this.maximumRedeliveries + "]";
    }

    public RedeliveryPolicyDefinition backOffMultiplier(double backOffMultiplier) {
        this.setBackOffMultiplier(backOffMultiplier);
        return this;
    }

    public RedeliveryPolicyDefinition collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.setCollisionAvoidanceFactor(collisionAvoidancePercent * 0.01);
        return this;
    }

    public RedeliveryPolicyDefinition collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.setCollisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public RedeliveryPolicyDefinition redeliveryDelay(long delay) {
        this.setRedeliveryDelay(delay);
        return this;
    }

    public RedeliveryPolicyDefinition retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public RedeliveryPolicyDefinition retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public RedeliveryPolicyDefinition logStackTrace(boolean logStackTrace) {
        this.setLogStackTrace(logStackTrace);
        return this;
    }

    public RedeliveryPolicyDefinition logRetryStackTrace(boolean logRetryStackTrace) {
        this.setLogRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public RedeliveryPolicyDefinition logRetryAttempted(boolean logRetryAttempted) {
        this.setLogRetryAttempted(logRetryAttempted);
        return this;
    }

    public RedeliveryPolicyDefinition logHandled(boolean logHandled) {
        this.setLogHandled(logHandled);
        return this;
    }

    public RedeliveryPolicyDefinition logContinued(boolean logContinued) {
        this.setLogContinued(logContinued);
        return this;
    }

    public RedeliveryPolicyDefinition logExhausted(boolean logExhausted) {
        this.setLogExhausted(logExhausted);
        return this;
    }

    public RedeliveryPolicyDefinition maximumRedeliveries(int maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicyDefinition useCollisionAvoidance() {
        this.setUseCollisionAvoidance(Boolean.TRUE);
        return this;
    }

    public RedeliveryPolicyDefinition useExponentialBackOff() {
        this.setUseExponentialBackOff(Boolean.TRUE);
        return this;
    }

    public RedeliveryPolicyDefinition maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.setMaximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicyDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }

    public RedeliveryPolicyDefinition delayPattern(String delayPattern) {
        this.setDelayPattern(delayPattern);
        return this;
    }

    public Double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(Double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public Double getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(Double collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public Long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(Long delay) {
        this.redeliveryDelay = delay;
    }

    public Boolean getAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(Boolean asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public Integer getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(Integer maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public Boolean getUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(Boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public Boolean getUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(Boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public Long getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(Long maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public void setRetriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public LoggingLevel getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public LoggingLevel getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Boolean getLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(Boolean logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public Boolean getDisableRedelivery() {
        return this.disableRedelivery;
    }

    public void setDisableRedelivery(Boolean disableRedelivery) {
        this.disableRedelivery = disableRedelivery;
    }

    public Boolean isLogRetryStackTrace() {
        return this.logRetryStackTrace;
    }

    public void setLogRetryStackTrace(Boolean logRetryStackTrace) {
        this.logRetryStackTrace = logRetryStackTrace;
    }

    public Boolean isLogHandled() {
        return this.logHandled;
    }

    public void setLogHandled(Boolean logHandled) {
        this.logHandled = logHandled;
    }

    public Boolean getLogContinued() {
        return this.logContinued;
    }

    public void setLogContinued(Boolean logContinued) {
        this.logContinued = logContinued;
    }

    public Boolean isLogRetryAttempted() {
        return this.logRetryAttempted;
    }

    public void setLogRetryAttempted(Boolean logRetryAttempted) {
        this.logRetryAttempted = logRetryAttempted;
    }

    public Boolean isLogExhausted() {
        return this.logExhausted;
    }

    public void setLogExhausted(Boolean logExhausted) {
        this.logExhausted = logExhausted;
    }

    public String getDelayPattern() {
        return this.delayPattern;
    }

    public void setDelayPattern(String delayPattern) {
        this.delayPattern = delayPattern;
    }
}

