/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import org.apache.helix.HelixException;
import org.apache.helix.alerts.Aggregator;
import org.apache.helix.alerts.Tuple;

public class DecayAggregator
extends Aggregator {
    double _decayWeight;

    public DecayAggregator(double weight) {
        this._decayWeight = weight;
    }

    public DecayAggregator() {
        this._numArgs = 1;
    }

    @Override
    public void merge(Tuple<String> currValTup, Tuple<String> newValTup, Tuple<String> currTimeTup, Tuple<String> newTimeTup, String ... args) {
        double mergedTime;
        double mergedVal;
        this._decayWeight = Double.parseDouble(args[0]);
        double currVal = 0.0;
        double currTime = -1.0;
        if (currValTup == null || newValTup == null || currTimeTup == null || newTimeTup == null) {
            throw new HelixException("Tuples cannot be null");
        }
        if (currValTup.size() > 0 && currTimeTup.size() > 0) {
            currVal = Double.parseDouble(currValTup.iterator().next());
            currTime = Double.parseDouble(currTimeTup.iterator().next());
        }
        double newVal = Double.parseDouble(newValTup.iterator().next());
        double newTime = Double.parseDouble(newTimeTup.iterator().next());
        if (newTime > currTime) {
            mergedVal = (1.0 - this._decayWeight) * currVal + this._decayWeight * newVal;
            mergedTime = newTime;
        } else {
            mergedVal = currVal;
            mergedTime = currTime;
        }
        currValTup.clear();
        currValTup.add(Double.toString(mergedVal));
        currTimeTup.clear();
        currTimeTup.add(Double.toString(mergedTime));
    }
}

