/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.restlet;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.restlet.ZNRecordUpdate;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.Client;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class ZkPropertyTransferClient {
    private static Logger LOG = Logger.getLogger(ZkPropertyTransferClient.class);
    public static final int DEFAULT_MAX_CONCURRENTTASKS = 2;
    public static int SEND_PERIOD = 10000;
    public static final String USE_PROPERTYTRANSFER = "UsePropertyTransfer";
    int _maxConcurrentTasks;
    ExecutorService _executorService;
    Client[] _clients;
    AtomicInteger _requestCount = new AtomicInteger(0);
    AtomicReference<ConcurrentHashMap<String, ZNRecordUpdate>> _dataBufferRef = new AtomicReference();
    Timer _timer;
    volatile String _webServiceUrl = "";

    public ZkPropertyTransferClient(int maxConcurrentTasks) {
        this._maxConcurrentTasks = maxConcurrentTasks;
        this._executorService = Executors.newFixedThreadPool(this._maxConcurrentTasks);
        this._clients = new Client[this._maxConcurrentTasks];
        for (int i = 0; i < this._clients.length; ++i) {
            this._clients[i] = new Client(Protocol.HTTP);
        }
        this._timer = new Timer(true);
        this._timer.schedule((TimerTask)new SendZNRecordTimerTask(), SEND_PERIOD, (long)SEND_PERIOD);
        this._dataBufferRef.getAndSet(new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueZNRecordUpdate(ZNRecordUpdate update, String webserviceUrl) {
        try {
            LOG.info((Object)("Enqueue update to " + update.getPath() + " opcode: " + (Object)((Object)update.getOpcode()) + " to " + webserviceUrl));
            this._webServiceUrl = webserviceUrl;
            update.getRecord().setSimpleField(USE_PROPERTYTRANSFER, "true");
            AtomicReference<ConcurrentHashMap<String, ZNRecordUpdate>> atomicReference = this._dataBufferRef;
            synchronized (atomicReference) {
                if (this._dataBufferRef.get().containsKey(update._path)) {
                    ZNRecord oldVal = this._dataBufferRef.get().get(update.getPath()).getRecord();
                    this._dataBufferRef.get().get((Object)update.getPath())._record = oldVal = (ZNRecord)update.getZNRecordUpdater().update((Object)oldVal);
                } else {
                    this._dataBufferRef.get().put(update.getPath(), update);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUpdateBatch() {
        LOG.debug((Object)("Actual sending update with " + this._dataBufferRef.get().size() + " updates to " + this._webServiceUrl));
        Map updateCache = null;
        AtomicReference<ConcurrentHashMap<String, ZNRecordUpdate>> atomicReference = this._dataBufferRef;
        synchronized (atomicReference) {
            updateCache = this._dataBufferRef.getAndSet(new ConcurrentHashMap());
        }
        if (updateCache != null && updateCache.size() > 0) {
            ZNRecordUpdateUploadTask task = new ZNRecordUpdateUploadTask(updateCache, this._webServiceUrl, this._clients[this._requestCount.intValue() % this._maxConcurrentTasks]);
            this._requestCount.incrementAndGet();
            this._executorService.submit(task);
            LOG.trace((Object)("Queue size :" + ((ThreadPoolExecutor)this._executorService).getQueue().size()));
        }
    }

    public void shutdown() {
        LOG.info((Object)"Shutting down ZkPropertyTransferClient");
        this._executorService.shutdown();
        this._timer.cancel();
        for (Client client : this._clients) {
            try {
                client.stop();
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
    }

    class ZNRecordUpdateUploadTask
    implements Callable<Void> {
        Map<String, ZNRecordUpdate> _updateMap;
        String _webServiceUrl;
        Client _client;

        ZNRecordUpdateUploadTask(Map<String, ZNRecordUpdate> update, String webserviceUrl, Client client) {
            this._updateMap = update;
            this._webServiceUrl = webserviceUrl;
            this._client = client;
        }

        @Override
        public Void call() throws Exception {
            LOG.debug((Object)("Actual sending update with " + this._updateMap.size() + " updates to " + this._webServiceUrl));
            long time = System.currentTimeMillis();
            Reference resourceRef = new Reference(this._webServiceUrl);
            Request request = new Request(Method.PUT, resourceRef);
            ObjectMapper mapper = new ObjectMapper();
            StringWriter sw = new StringWriter();
            try {
                mapper.writeValue((Writer)sw, this._updateMap);
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
            request.setEntity("ZNRecordUpdate=" + sw, MediaType.APPLICATION_ALL);
            Response response = this._client.handle(request);
            if (response.getStatus().getCode() != Status.SUCCESS_OK.getCode()) {
                LOG.error((Object)("Status : " + response.getStatus()));
            }
            LOG.info((Object)("Using time : " + (System.currentTimeMillis() - time)));
            return null;
        }
    }

    class SendZNRecordTimerTask
    extends TimerTask {
        SendZNRecordTimerTask() {
        }

        @Override
        public void run() {
            ZkPropertyTransferClient.this.sendUpdateBatch();
        }
    }
}

