/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.List;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.manager.zk.Cache;
import org.apache.helix.store.zk.ZNode;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;

public class WriteThroughCache<T>
extends Cache<T> {
    private static Logger LOG = Logger.getLogger(WriteThroughCache.class);
    final BaseDataAccessor<T> _accessor;

    public WriteThroughCache(BaseDataAccessor<T> accessor, List<String> paths) {
        this._accessor = accessor;
        if (paths != null && !paths.isEmpty()) {
            for (String path : paths) {
                this.updateRecursive(path);
            }
        }
    }

    @Override
    public void update(String path, T data, Stat stat) {
        String parentPath = HelixUtil.getZkParentPath(path);
        String childName = HelixUtil.getZkName(path);
        this.addToParentChildSet(parentPath, childName);
        ZNode znode = (ZNode)this._cache.get(path);
        if (znode == null) {
            this._cache.put(path, new ZNode(path, data, stat));
        } else {
            znode.setData(data);
            znode.setStat(stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecursive(String path) {
        if (path == null) {
            return;
        }
        try {
            this._lock.writeLock().lock();
            Stat stat = new Stat();
            T readData = this._accessor.get(path, stat, AccessOption.THROW_EXCEPTION_IFNOTEXIST);
            this.update(path, readData, stat);
            ZNode znode = (ZNode)this._cache.get(path);
            List<String> childNames = this._accessor.getChildNames(path, 0);
            if (childNames != null && childNames.size() > 0) {
                for (String childName : childNames) {
                    String childPath = path + "/" + childName;
                    if (znode.hasChild(childName)) continue;
                    znode.addChild(childName);
                    this.updateRecursive(childPath);
                }
            }
        }
        catch (ZkNoNodeException zkNoNodeException) {
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }
}

