/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.Criteria;
import org.apache.helix.HelixManager;
import org.apache.helix.josql.ClusterJosqlQueryProcessor;
import org.apache.log4j.Logger;

public class CriteriaEvaluator {
    private static Logger logger = Logger.getLogger(CriteriaEvaluator.class);

    public List<Map<String, String>> evaluateCriteria(Criteria recipientCriteria, HelixManager manager) {
        ArrayList<Map<String, String>> selected = new ArrayList<Map<String, String>>();
        String queryFields = (!recipientCriteria.getInstanceName().equals("") ? " mapSubKey" : " ''") + "," + (!recipientCriteria.getResource().equals("") ? " recordId" : " ''") + "," + (!recipientCriteria.getPartition().equals("") ? " mapKey" : " ''") + "," + (!recipientCriteria.getPartitionState().equals("") ? " mapValue" : " '' ");
        String matchCondition = "mapSubKey LIKE '" + (!recipientCriteria.getInstanceName().equals("") ? recipientCriteria.getInstanceName() + "'" : "%' ") + " AND " + "recordId" + " LIKE '" + (!recipientCriteria.getResource().equals("") ? recipientCriteria.getResource() + "'" : "%' ") + " AND " + "mapKey" + " LIKE '" + (!recipientCriteria.getPartition().equals("") ? recipientCriteria.getPartition() + "'" : "%' ") + " AND " + "mapValue" + " LIKE '" + (!recipientCriteria.getPartitionState().equals("") ? recipientCriteria.getPartitionState() + "'" : "%' ") + " AND " + "mapSubKey" + " IN ((SELECT [*]id FROM :LIVEINSTANCES))";
        String queryTarget = recipientCriteria.getDataSource().toString() + ".Table";
        String josql = "SELECT DISTINCT " + queryFields + " FROM " + queryTarget + " WHERE " + matchCondition;
        ClusterJosqlQueryProcessor p = new ClusterJosqlQueryProcessor(manager);
        List<Object> result = new ArrayList();
        try {
            logger.info((Object)("JOSQL query: " + josql));
            result = p.runJoSqlQuery(josql, null, null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return selected;
        }
        for (Object o : result) {
            HashMap<String, String> resultRow = new HashMap<String, String>();
            List row = (List)o;
            resultRow.put("instanceName", (String)row.get(0));
            resultRow.put("resourceName", (String)row.get(1));
            resultRow.put("partitionName", (String)row.get(2));
            resultRow.put("partitionState", (String)row.get(3));
            selected.add(resultRow);
        }
        logger.info((Object)("JOSQL query return " + selected.size() + " rows"));
        return selected;
    }
}

