/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.config;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileSystemAlreadyExistsException;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.StandardOpenOption;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigGroupMarshaller;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.security.Identity;

@ApplicationScoped
public class ConfigurationServiceImpl
implements ConfigurationService {
    @Inject
    @Named(value="system")
    private Repository systemRepository;
    @Inject
    private ConfigGroupMarshaller marshaller;
    @Inject
    private Identity identity;
    private final Map<ConfigType, List<ConfigGroup>> configuration = new HashMap<ConfigType, List<ConfigGroup>>();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    @PostConstruct
    public void setup() {
        try {
            this.ioService.newFileSystem(URI.create(this.systemRepository.getUri()), this.systemRepository.getEnvironment(), (FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
    }

    public List<ConfigGroup> getConfiguration(final ConfigType type) {
        if (this.configuration.containsKey(type)) {
            return this.configuration.get(type);
        }
        ArrayList<ConfigGroup> configGroups = new ArrayList<ConfigGroup>();
        DirectoryStream foundConfigs = this.ioService.newDirectoryStream(this.ioService.get(this.systemRepository.getUri(), new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws org.kie.commons.java.nio.IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && entry.getFileName().toString().endsWith(type.getExt());
            }
        });
        Iterator it = foundConfigs.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String content = this.ioService.readAllString((Path)it.next());
                ConfigGroup configGroup = this.marshaller.unmarshall(content);
                configGroups.add(configGroup);
            }
            this.configuration.put(type, configGroups);
        }
        return configGroups;
    }

    public boolean addConfiguration(ConfigGroup configGroup) {
        try {
            Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(configGroup.getName() + configGroup.getType().getExt());
            CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Created config " + filePath.getFileName());
            OutputStream outputStream = this.ioService.newOutputStream(filePath, new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, commentedOption});
            String xml = this.marshaller.marshall(configGroup);
            outputStream.write(xml.getBytes("UTF-8"));
            outputStream.close();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Error when creating asset", e);
        }
    }

    public boolean removeConfiguration(ConfigGroup configGroup) {
        return this.ioService.deleteIfExists(this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(configGroup.getName() + configGroup.getType().getExt()));
    }

    protected String getIdentityName() {
        try {
            return this.identity.getName();
        }
        catch (ContextNotActiveException e) {
            return "unknown";
        }
    }
}

