/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.backend.group.Group;
import org.uberfire.backend.group.GroupService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigItem;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.group.GroupFactory;

@ApplicationScoped
public class GroupServiceImpl
implements GroupService {
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private GroupFactory groupFactory;
    private Map<String, Group> registeredGroups = new HashMap<String, Group>();

    @PostConstruct
    public void loadGroups() {
        List groups = this.configurationService.getConfiguration(ConfigType.GROUP);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                Group group = this.groupFactory.newGroup(groupConfig);
                this.registeredGroups.put(group.getName(), group);
            }
        }
    }

    public Group getGroup(String name) {
        return this.registeredGroups.get(name);
    }

    public Collection<Group> getGroups() {
        return Collections.unmodifiableCollection(this.registeredGroups.values());
    }

    public void createGroup(String name, String owner) {
        ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.GROUP, name, "");
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
        this.configurationService.addConfiguration(groupConfig);
    }

    public void createGroup(String name, String owner, Collection<Repository> repositories) {
        ConfigGroup groupConfig = this.configurationFactory.newConfigGroup(ConfigType.GROUP, name, "");
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("owner", owner));
        ArrayList<String> repositoryList = new ArrayList<String>();
        for (Repository repo : repositories) {
            repositoryList.add(repo.getAlias());
        }
        groupConfig.addConfigItem(this.configurationFactory.newConfigItem("repositories", repositoryList));
        this.configurationService.addConfiguration(groupConfig);
    }

    public void addRepository(Group group, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(group.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("Group " + group.getName() + " not found");
        }
        ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
        ((List)repositories.getValue()).add(repository.getAlias());
        this.configurationService.addConfiguration(thisGroupConfig);
        Group updatedGroup = this.groupFactory.newGroup(thisGroupConfig);
        this.registeredGroups.put(updatedGroup.getName(), updatedGroup);
    }

    public void removeRepository(Group group, Repository repository) {
        ConfigGroup thisGroupConfig = this.findGroupConfig(group.getName());
        if (thisGroupConfig == null) {
            throw new IllegalArgumentException("Group " + group.getName() + " not found");
        }
        ConfigItem repositories = thisGroupConfig.getConfigItem("repositories");
        ((List)repositories.getValue()).remove(repository.getAlias());
        this.configurationService.addConfiguration(thisGroupConfig);
        Group updatedGroup = this.groupFactory.newGroup(thisGroupConfig);
        this.registeredGroups.put(updatedGroup.getName(), updatedGroup);
    }

    protected ConfigGroup findGroupConfig(String name) {
        List groups = this.configurationService.getConfiguration(ConfigType.GROUP);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(name)) continue;
                return groupConfig;
            }
        }
        return null;
    }
}

