/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.echo;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EchoServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(EchoServerHandler.class.getName());
    private final AtomicLong transferredBytes = new AtomicLong();

    public long getTransferredBytes() {
        return this.transferredBytes.get();
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        this.transferredBytes.addAndGet(((ChannelBuffer)e.getMessage()).readableBytes());
        e.getChannel().write(e.getMessage());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }
}

