/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.bootstrap.ClientBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.nio.NioClientSocketChannelFactory;
import io.netty.example.factorial.FactorialClientHandler;
import io.netty.example.factorial.FactorialClientPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class FactorialClient {
    private final String host;
    private final int port;
    private final int count;

    public FactorialClient(String host, int port, int count) {
        this.host = host;
        this.port = port;
        this.count = count;
    }

    public void run() {
        ClientBootstrap bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new FactorialClientPipelineFactory(this.count));
        ChannelFuture connectFuture = bootstrap.connect(new InetSocketAddress(this.host, this.port));
        Channel channel = connectFuture.awaitUninterruptibly().getChannel();
        FactorialClientHandler handler = (FactorialClientHandler)channel.getPipeline().getLast();
        System.err.format("Factorial of %,d is: %,d", this.count, handler.getFactorial());
        bootstrap.releaseExternalResources();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: " + FactorialClient.class.getSimpleName() + " <host> <port> <count>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int count = Integer.parseInt(args[2]);
        if (count <= 0) {
            throw new IllegalArgumentException("count must be a positive integer.");
        }
        new FactorialClient(host, port, count).run();
    }
}

