/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.Channels;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import io.netty.handler.codec.http.Attribute;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.CookieEncoder;
import io.netty.handler.codec.http.DefaultHttpDataFactory;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DiskAttribute;
import io.netty.handler.codec.http.DiskFileUpload;
import io.netty.handler.codec.http.FileUpload;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpDataFactory;
import io.netty.handler.codec.http.HttpPostRequestDecoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.InterfaceHttpData;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpUploadServerHandler
extends SimpleChannelUpstreamHandler {
    private volatile HttpRequest request;
    private volatile boolean readingChunks;
    private final StringBuilder responseContent = new StringBuilder();
    private static final HttpDataFactory factory = new DefaultHttpDataFactory(DefaultHttpDataFactory.MINSIZE);
    private HttpPostRequestDecoder decoder;

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.decoder != null) {
            this.decoder.cleanFiles();
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.readingChunks) {
            Set<Object> cookies;
            HttpRequest request;
            URI uri;
            if (this.decoder != null) {
                this.decoder.cleanFiles();
                this.decoder = null;
            }
            if (!(uri = new URI((request = (this.request = (HttpRequest)e.getMessage())).getUri())).getPath().startsWith("/form")) {
                this.writeMenu(e);
                return;
            }
            this.responseContent.setLength(0);
            this.responseContent.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.responseContent.append("===================================\r\n");
            this.responseContent.append("VERSION: " + request.getProtocolVersion().getText() + "\r\n");
            this.responseContent.append("REQUEST_URI: " + request.getUri() + "\r\n\r\n");
            this.responseContent.append("\r\n\r\n");
            List<Map.Entry<String, String>> headers = request.getHeaders();
            for (Map.Entry<String, String> entry : headers) {
                this.responseContent.append("HEADER: " + entry.getKey() + "=" + entry.getValue() + "\r\n");
            }
            this.responseContent.append("\r\n\r\n");
            String value = request.getHeader("Cookie");
            if (value == null) {
                cookies = Collections.emptySet();
            } else {
                CookieDecoder decoder = new CookieDecoder();
                cookies = decoder.decode(value);
            }
            for (Cookie cookie : cookies) {
                this.responseContent.append("COOKIE: " + cookie.toString() + "\r\n");
            }
            this.responseContent.append("\r\n\r\n");
            QueryStringDecoder decoderQuery = new QueryStringDecoder(request.getUri());
            Map<String, List<String>> uriAttributes = decoderQuery.getParameters();
            for (String key : uriAttributes.keySet()) {
                for (String valuen : uriAttributes.get(key)) {
                    this.responseContent.append("URI: " + key + "=" + valuen + "\r\n");
                }
            }
            this.responseContent.append("\r\n\r\n");
            try {
                this.decoder = new HttpPostRequestDecoder(factory, request);
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                e1.printStackTrace();
                this.responseContent.append(e1.getMessage());
                this.writeResponse(e.getChannel());
                Channels.close(e.getChannel());
                return;
            }
            catch (HttpPostRequestDecoder.IncompatibleDataDecoderException e1) {
                this.responseContent.append(e1.getMessage());
                this.responseContent.append("\r\n\r\nEND OF GET CONTENT\r\n");
                this.writeResponse(e.getChannel());
                return;
            }
            this.responseContent.append("Is Chunked: " + request.isChunked() + "\r\n");
            this.responseContent.append("IsMultipart: " + this.decoder.isMultipart() + "\r\n");
            if (request.isChunked()) {
                this.responseContent.append("Chunks: ");
                this.readingChunks = true;
            } else {
                this.readHttpDataAllReceive(e.getChannel());
                this.responseContent.append("\r\n\r\nEND OF NOT CHUNKED CONTENT\r\n");
                this.writeResponse(e.getChannel());
            }
        } else {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            try {
                this.decoder.offer(chunk);
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                e1.printStackTrace();
                this.responseContent.append(e1.getMessage());
                this.writeResponse(e.getChannel());
                Channels.close(e.getChannel());
                return;
            }
            this.responseContent.append("o");
            this.readHttpDataChunkByChunk(e.getChannel());
            if (chunk.isLast()) {
                this.readHttpDataAllReceive(e.getChannel());
                this.writeResponse(e.getChannel());
                this.readingChunks = false;
            }
        }
    }

    private void readHttpDataAllReceive(Channel channel) {
        List<InterfaceHttpData> datas = null;
        try {
            datas = this.decoder.getBodyHttpDatas();
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException e1) {
            e1.printStackTrace();
            this.responseContent.append(e1.getMessage());
            this.writeResponse(channel);
            Channels.close(channel);
            return;
        }
        for (InterfaceHttpData data : datas) {
            this.writeHttpData(data);
        }
        this.responseContent.append("\r\n\r\nEND OF CONTENT AT FINAL END\r\n");
    }

    private void readHttpDataChunkByChunk(Channel channel) {
        try {
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (data == null) continue;
                this.writeHttpData(data);
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException e1) {
            this.responseContent.append("\r\n\r\nEND OF CONTENT CHUNK BY CHUNK\r\n\r\n");
        }
    }

    private void writeHttpData(InterfaceHttpData data) {
        if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.Attribute) {
            String value;
            Attribute attribute = (Attribute)data;
            try {
                value = attribute.getValue();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.getName() + " Error while reading value: " + e1.getMessage() + "\r\n");
                return;
            }
            if (value.length() > 100) {
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.getName() + " data too long\r\n");
            } else {
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.toString() + "\r\n");
            }
        } else {
            this.responseContent.append("\r\nBODY FileUpload: " + data.getHttpDataType().name() + ": " + data.toString() + "\r\n");
            if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                FileUpload fileUpload = (FileUpload)data;
                if (fileUpload.isCompleted()) {
                    if (fileUpload.length() < 10000L) {
                        this.responseContent.append("\tContent of file\r\n");
                        try {
                            this.responseContent.append(((FileUpload)data).getString(((FileUpload)data).getCharset()));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        this.responseContent.append("\r\n");
                    } else {
                        this.responseContent.append("\tFile too long to be printed out:" + fileUpload.length() + "\r\n");
                    }
                } else {
                    this.responseContent.append("\tFile to be continued but should not!\r\n");
                }
            }
        }
    }

    private void writeResponse(Channel channel) {
        Set<Object> cookies;
        String value;
        ChannelBuffer buf = ChannelBuffers.copiedBuffer(this.responseContent.toString(), CharsetUtil.UTF_8);
        this.responseContent.setLength(0);
        boolean close = "close".equalsIgnoreCase(this.request.getHeader("Connection")) || this.request.getProtocolVersion().equals(HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.getHeader("Connection"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setContent(buf);
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        if (!close) {
            response.setHeader("Content-Length", String.valueOf(buf.readableBytes()));
        }
        if ((value = this.request.getHeader("Cookie")) == null) {
            cookies = Collections.emptySet();
        } else {
            CookieDecoder decoder = new CookieDecoder();
            cookies = decoder.decode(value);
        }
        if (!cookies.isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", cookieEncoder.encode());
        }
        ChannelFuture future = channel.write(response);
        if (close) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private void writeMenu(MessageEvent e) {
        this.responseContent.setLength(0);
        this.responseContent.append("<html>");
        this.responseContent.append("<head>");
        this.responseContent.append("<title>Netty Test Form</title>\r\n");
        this.responseContent.append("</head>\r\n");
        this.responseContent.append("<body bgcolor=white><style>td{font-size: 12pt;}</style>");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr>");
        this.responseContent.append("<td>");
        this.responseContent.append("<h1>Netty Test Form</h1>");
        this.responseContent.append("Choose one FORM");
        this.responseContent.append("</td>");
        this.responseContent.append("</tr>");
        this.responseContent.append("</table>\r\n");
        this.responseContent.append("<CENTER>GET FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formget\" METHOD=\"GET\">");
        this.responseContent.append("<input type=hidden name=getform value=\"GET\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<CENTER>POST FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formpost\" METHOD=\"POST\">");
        this.responseContent.append("<input type=hidden name=getform value=\"POST\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("<tr><td>Fill with file (only file name will be transmitted): <br> <input type=file name=\"myfile\">");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<CENTER>POST MULTIPART FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formpostmultipart\" ENCTYPE=\"multipart/form-data\" METHOD=\"POST\">");
        this.responseContent.append("<input type=hidden name=getform value=\"POST\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("<tr><td>Fill with file: <br> <input type=file name=\"myfile\">");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("</body>");
        this.responseContent.append("</html>");
        ChannelBuffer buf = ChannelBuffers.copiedBuffer(this.responseContent.toString(), CharsetUtil.UTF_8);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setContent(buf);
        response.setHeader("Content-Type", "text/html; charset=UTF-8");
        response.setHeader("Content-Length", String.valueOf(buf.readableBytes()));
        e.getChannel().write(response);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        System.err.println(this.responseContent.toString());
        e.getChannel().close();
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
    }
}

