/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp;

import io.netty.buffer.ChannelBuffers;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import io.netty.channel.sctp.SctpFrame;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SctpClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(SctpClientHandler.class.getName());
    private final AtomicLong counter = new AtomicLong(0L);

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent stateEvent) {
        stateEvent.getChannel().write(new SctpFrame(0, 0, ChannelBuffers.wrappedBuffer("SCTP ECHO".getBytes())));
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) {
        logger.log(Level.INFO, "Received " + this.counter.incrementAndGet() + "th message from server, sending it back.");
        messageEvent.getChannel().write(messageEvent.getMessage());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", exceptionEvent.getCause());
        exceptionEvent.getChannel().close();
    }
}

