/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.securechat.SecureChatServerPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class SecureChatServer {
    private final int port;

    public SecureChatServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new SecureChatServerPipelineFactory());
        bootstrap.bind(new InetSocketAddress(this.port));
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8443;
        new SecureChatServer(port).run();
    }
}

