/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpCodecUtil;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.oneone.OneToOneEncoder;
import io.netty.util.CharsetUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class HttpMessageEncoder
extends OneToOneEncoder {
    private static final ChannelBuffer LAST_CHUNK = ChannelBuffers.copiedBuffer("0\r\n\r\n", CharsetUtil.US_ASCII);
    private volatile boolean chunked;

    protected HttpMessageEncoder() {
    }

    @Override
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof HttpMessage) {
            boolean chunked;
            HttpMessage m = (HttpMessage)msg;
            if (m.isChunked()) {
                if (!HttpCodecUtil.isTransferEncodingChunked(m)) {
                    m.addHeader("Transfer-Encoding", "chunked");
                }
                this.chunked = true;
                chunked = true;
            } else {
                chunked = this.chunked = HttpCodecUtil.isTransferEncodingChunked(m);
            }
            ChannelBuffer header = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
            this.encodeInitialLine(header, m);
            this.encodeHeaders(header, m);
            header.writeByte(13);
            header.writeByte(10);
            ChannelBuffer content = m.getContent();
            if (!content.readable()) {
                return header;
            }
            if (chunked) {
                throw new IllegalArgumentException("HttpMessage.content must be empty if Transfer-Encoding is chunked.");
            }
            return ChannelBuffers.wrappedBuffer(header, content);
        }
        if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            if (this.chunked) {
                if (chunk.isLast()) {
                    this.chunked = false;
                    if (chunk instanceof HttpChunkTrailer) {
                        ChannelBuffer trailer = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
                        trailer.writeByte(48);
                        trailer.writeByte(13);
                        trailer.writeByte(10);
                        this.encodeTrailingHeaders(trailer, (HttpChunkTrailer)chunk);
                        trailer.writeByte(13);
                        trailer.writeByte(10);
                        return trailer;
                    }
                    return LAST_CHUNK.duplicate();
                }
                ChannelBuffer content = chunk.getContent();
                int contentLength = content.readableBytes();
                return ChannelBuffers.wrappedBuffer(ChannelBuffers.copiedBuffer(Integer.toHexString(contentLength), CharsetUtil.US_ASCII), ChannelBuffers.wrappedBuffer(HttpCodecUtil.CRLF), content.slice(content.readerIndex(), contentLength), ChannelBuffers.wrappedBuffer(HttpCodecUtil.CRLF));
            }
            if (chunk.isLast()) {
                return null;
            }
            return chunk.getContent();
        }
        return msg;
    }

    private void encodeHeaders(ChannelBuffer buf, HttpMessage message) {
        try {
            for (Map.Entry<String, String> h : message.getHeaders()) {
                this.encodeHeader(buf, h.getKey(), h.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw (Error)new Error().initCause(e);
        }
    }

    private void encodeTrailingHeaders(ChannelBuffer buf, HttpChunkTrailer trailer) {
        try {
            for (Map.Entry<String, String> h : trailer.getHeaders()) {
                this.encodeHeader(buf, h.getKey(), h.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw (Error)new Error().initCause(e);
        }
    }

    private void encodeHeader(ChannelBuffer buf, String header, String value) throws UnsupportedEncodingException {
        buf.writeBytes(header.getBytes("ASCII"));
        buf.writeByte(58);
        buf.writeByte(32);
        buf.writeBytes(value.getBytes("ASCII"));
        buf.writeByte(13);
        buf.writeByte(10);
    }

    protected abstract void encodeInitialLine(ChannelBuffer var1, HttpMessage var2) throws Exception;
}

