/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class WebSocketServerHandshaker {
    private final String webSocketUrl;
    private final String[] subprotocols;
    private final WebSocketVersion version;

    protected WebSocketServerHandshaker(WebSocketVersion version, String webSocketUrl, String subprotocols) {
        this.version = version;
        this.webSocketUrl = webSocketUrl;
        if (subprotocols != null) {
            String[] subprotocolArray = subprotocols.split(",");
            for (int i = 0; i < subprotocolArray.length; ++i) {
                subprotocolArray[i] = subprotocolArray[i].trim();
            }
            this.subprotocols = subprotocolArray;
        } else {
            this.subprotocols = new String[0];
        }
    }

    public String getWebSocketUrl() {
        return this.webSocketUrl;
    }

    public Set<String> getSubprotocols() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (String p : this.subprotocols) {
            ret.add(p);
        }
        return ret;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public abstract ChannelFuture handshake(Channel var1, HttpRequest var2);

    public abstract ChannelFuture close(Channel var1, CloseWebSocketFrame var2);

    protected String selectSubprotocol(String requestedSubprotocols) {
        String[] requesteSubprotocolArray;
        if (requestedSubprotocols == null || this.subprotocols.length == 0) {
            return null;
        }
        for (String p : requesteSubprotocolArray = requestedSubprotocols.split(",")) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : this.subprotocols) {
                if (!requestedSubprotocol.equals(supportedSubprotocol)) continue;
                return requestedSubprotocol;
            }
        }
        return null;
    }
}

