/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.Channels;
import io.netty.handler.codec.frame.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.oneone.OneToOneDecoder;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyHeaderBlock;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpdyHttpDecoder
extends OneToOneDecoder {
    private final int maxContentLength;
    private final Map<Integer, HttpMessage> messageMap = new HashMap<Integer, HttpMessage>();

    public SpdyHttpDecoder(int maxContentLength) {
        if (maxContentLength <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + maxContentLength);
        }
        this.maxContentLength = maxContentLength;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof SpdySynStreamFrame) {
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamID = spdySynStreamFrame.getStreamID();
            if (SpdyCodecUtil.isServerID(streamID)) {
                String URL2;
                int associatedToStreamID = spdySynStreamFrame.getAssociatedToStreamID();
                if (associatedToStreamID == 0) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.INVALID_STREAM);
                    Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                }
                if ((URL2 = SpdyHeaders.getUrl(spdySynStreamFrame)) == null) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                    Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                }
                try {
                    HttpResponse httpResponse = this.createHttpResponse(spdySynStreamFrame);
                    SpdyHttpHeaders.setStreamID(httpResponse, streamID);
                    SpdyHttpHeaders.setAssociatedToStreamID(httpResponse, associatedToStreamID);
                    SpdyHttpHeaders.setPriority(httpResponse, spdySynStreamFrame.getPriority());
                    SpdyHttpHeaders.setUrl(httpResponse, URL2);
                    if (spdySynStreamFrame.isLast()) {
                        HttpHeaders.setContentLength(httpResponse, 0L);
                        return httpResponse;
                    }
                    this.messageMap.put(new Integer(streamID), httpResponse);
                }
                catch (Exception e) {
                    DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                    Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
                }
            } else {
                try {
                    HttpRequest httpRequest = this.createHttpRequest(spdySynStreamFrame);
                    SpdyHttpHeaders.setStreamID(httpRequest, streamID);
                    if (spdySynStreamFrame.isLast()) {
                        return httpRequest;
                    }
                    this.messageMap.put(new Integer(streamID), httpRequest);
                }
                catch (Exception e) {
                    DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamID);
                    spdySynReplyFrame.setLast(true);
                    SpdyHeaders.setStatus(spdySynReplyFrame, HttpResponseStatus.BAD_REQUEST);
                    SpdyHeaders.setVersion(spdySynReplyFrame, HttpVersion.HTTP_1_0);
                    Channels.write(ctx, Channels.future(channel), spdySynReplyFrame);
                }
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamID();
            try {
                HttpResponse httpResponse = this.createHttpResponse(spdySynReplyFrame);
                SpdyHttpHeaders.setStreamID(httpResponse, streamID);
                if (spdySynReplyFrame.isLast()) {
                    HttpHeaders.setContentLength(httpResponse, 0L);
                    return httpResponse;
                }
                this.messageMap.put(new Integer(streamID), httpResponse);
            }
            catch (Exception e) {
                DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                Channels.write(ctx, Channels.future(channel), spdyRstStreamFrame);
            }
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            Integer streamID = new Integer(spdyHeadersFrame.getStreamID());
            HttpMessage httpMessage = this.messageMap.get(streamID);
            if (httpMessage == null) {
                return null;
            }
            for (Map.Entry<String, String> e : spdyHeadersFrame.getHeaders()) {
                httpMessage.addHeader(e.getKey(), e.getValue());
            }
        } else if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            Integer streamID = new Integer(spdyDataFrame.getStreamID());
            HttpMessage httpMessage = this.messageMap.get(streamID);
            if (httpMessage == null) {
                return null;
            }
            ChannelBuffer content = httpMessage.getContent();
            if (content.readableBytes() > this.maxContentLength - spdyDataFrame.getData().readableBytes()) {
                this.messageMap.remove(streamID);
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            if (content == ChannelBuffers.EMPTY_BUFFER) {
                content = ChannelBuffers.dynamicBuffer(channel.getConfig().getBufferFactory());
                content.writeBytes(spdyDataFrame.getData());
                httpMessage.setContent(content);
            } else {
                content.writeBytes(spdyDataFrame.getData());
            }
            if (spdyDataFrame.isLast()) {
                HttpHeaders.setContentLength(httpMessage, content.readableBytes());
                this.messageMap.remove(streamID);
                return httpMessage;
            }
        }
        return null;
    }

    private HttpRequest createHttpRequest(SpdyHeaderBlock requestFrame) throws Exception {
        HttpMethod method = SpdyHeaders.getMethod(requestFrame);
        String url = SpdyHeaders.getUrl(requestFrame);
        HttpVersion version = SpdyHeaders.getVersion(requestFrame);
        SpdyHeaders.removeMethod(requestFrame);
        SpdyHeaders.removeUrl(requestFrame);
        SpdyHeaders.removeVersion(requestFrame);
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(version, method, url);
        for (Map.Entry<String, String> e : requestFrame.getHeaders()) {
            httpRequest.addHeader(e.getKey(), e.getValue());
        }
        List<String> encodings = httpRequest.getHeaders("Transfer-Encoding");
        encodings.remove("chunked");
        if (encodings.isEmpty()) {
            httpRequest.removeHeader("Transfer-Encoding");
        } else {
            httpRequest.setHeader("Transfer-Encoding", encodings);
        }
        HttpHeaders.setKeepAlive(httpRequest, true);
        return httpRequest;
    }

    private HttpResponse createHttpResponse(SpdyHeaderBlock responseFrame) throws Exception {
        HttpResponseStatus status = SpdyHeaders.getStatus(responseFrame);
        HttpVersion version = SpdyHeaders.getVersion(responseFrame);
        SpdyHeaders.removeStatus(responseFrame);
        SpdyHeaders.removeVersion(responseFrame);
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, status);
        for (Map.Entry<String, String> e : responseFrame.getHeaders()) {
            httpResponse.addHeader(e.getKey(), e.getValue());
        }
        List<String> encodings = httpResponse.getHeaders("Transfer-Encoding");
        encodings.remove("chunked");
        if (encodings.isEmpty()) {
            httpResponse.removeHeader("Transfer-Encoding");
        } else {
            httpResponse.setHeader("Transfer-Encoding", encodings);
        }
        httpResponse.removeHeader("Trailer");
        HttpHeaders.setKeepAlive(httpResponse, true);
        return httpResponse;
    }
}

