/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class PatternRule
implements IpFilterRule,
Comparable<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PatternRule.class);
    private Pattern ipPattern;
    private Pattern namePattern;
    private boolean isAllowRule = true;
    private boolean localhost;
    private String pattern;

    public PatternRule(boolean allow, String pattern) {
        this.isAllowRule = allow;
        this.pattern = pattern;
        this.parse(pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isAllowRule() {
        return this.isAllowRule;
    }

    @Override
    public boolean isDenyRule() {
        return !this.isAllowRule;
    }

    @Override
    public boolean contains(InetAddress inetAddress) {
        if (this.localhost && this.isLocalhost(inetAddress)) {
            return true;
        }
        if (this.ipPattern != null && this.ipPattern.matcher(inetAddress.getHostAddress()).matches()) {
            return true;
        }
        return this.namePattern != null && this.namePattern.matcher(inetAddress.getHostName()).matches();
    }

    private void parse(String pattern) {
        if (pattern == null) {
            return;
        }
        String[] acls = pattern.split(",");
        String ip = "";
        String name = "";
        for (String c : acls) {
            if ((c = c.trim()).equals("n:localhost")) {
                this.localhost = true;
                continue;
            }
            if (c.startsWith("n:")) {
                name = this.addRule(name, c.substring(2));
                continue;
            }
            if (!c.startsWith("i:")) continue;
            ip = this.addRule(ip, c.substring(2));
        }
        if (ip.length() != 0) {
            this.ipPattern = Pattern.compile(ip);
        }
        if (name.length() != 0) {
            this.namePattern = Pattern.compile(name);
        }
    }

    private String addRule(String pattern, String rule) {
        if (rule == null || rule.length() == 0) {
            return pattern;
        }
        if (pattern.length() != 0) {
            pattern = pattern + "|";
        }
        rule = rule.replaceAll("\\.", "\\\\.");
        rule = rule.replaceAll("\\*", ".*");
        rule = rule.replaceAll("\\?", ".");
        pattern = pattern + "(" + rule + ")";
        return pattern;
    }

    private boolean isLocalhost(InetAddress address) {
        block7: {
            block6: {
                try {
                    if (address.equals(InetAddress.getLocalHost())) {
                        return true;
                    }
                }
                catch (UnknownHostException e) {
                    if (!logger.isInfoEnabled()) break block6;
                    logger.info("error getting ip of localhost", e);
                }
            }
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName("127.0.0.1")) {
                    if (!addr.equals(address)) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info("error getting ip of localhost", e);
            }
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        if (!(o instanceof PatternRule)) {
            return -1;
        }
        PatternRule p = (PatternRule)o;
        if (p.isAllowRule() && !this.isAllowRule) {
            return -1;
        }
        if (this.pattern == null && p.pattern == null) {
            return 0;
        }
        if (this.pattern != null) {
            return this.pattern.compareTo(p.getPattern());
        }
        return -1;
    }
}

