/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.AbstractNioChannel;
import io.netty.channel.socket.nio.DefaultNioSocketChannelConfig;
import io.netty.channel.socket.nio.NioSocketChannelConfig;
import io.netty.channel.socket.nio.NioWorker;
import java.net.InetSocketAddress;

class NioSocketChannel
extends AbstractNioChannel<java.nio.channels.SocketChannel>
implements SocketChannel {
    private static final int ST_OPEN = 0;
    private static final int ST_BOUND = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSED = -1;
    volatile int state = 0;
    private final NioSocketChannelConfig config;

    public NioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, java.nio.channels.SocketChannel socket, NioWorker worker) {
        super(parent, factory, pipeline, sink, worker, socket);
        this.config = new DefaultNioSocketChannelConfig(socket.socket());
    }

    @Override
    public NioSocketChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state >= 0;
    }

    @Override
    public boolean isBound() {
        return this.state >= 1;
    }

    @Override
    public boolean isConnected() {
        return this.state == 2;
    }

    final void setBound() {
        assert (this.state == 0) : "Invalid state: " + this.state;
        this.state = 1;
    }

    final void setConnected() {
        if (this.state != -1) {
            this.state = 2;
        }
    }

    @Override
    protected boolean setClosed() {
        this.state = -1;
        return super.setClosed();
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.SocketChannel)this.channel).socket().getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.SocketChannel)this.channel).socket().getRemoteSocketAddress();
    }
}

