/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.uptime;

import io.netty.bootstrap.ClientBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.channel.socket.nio.NioClientSocketChannelFactory;
import io.netty.example.uptime.UptimeClientHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class UptimeClient {
    static final int RECONNECT_DELAY = 5;
    private static final int READ_TIMEOUT = 10;
    private final String host;
    private final int port;

    public UptimeClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void run() {
        final HashedWheelTimer timer = new HashedWheelTimer();
        final ClientBootstrap bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){
            private final ChannelHandler timeoutHandler;
            private final ChannelHandler uptimeHandler;
            {
                this.timeoutHandler = new ReadTimeoutHandler(timer, 10);
                this.uptimeHandler = new UptimeClientHandler(bootstrap, timer);
            }

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(this.timeoutHandler, this.uptimeHandler);
            }
        });
        bootstrap.setOption("remoteAddress", new InetSocketAddress(this.host, this.port));
        bootstrap.connect();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + UptimeClient.class.getSimpleName() + " <host> <port>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        new UptimeClient(host, port).run();
    }
}

