/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.execution;

import io.netty.channel.Channel;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelState;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.WriteCompletionEvent;
import io.netty.handler.execution.ChannelDownstreamEventRunnable;
import io.netty.handler.execution.ChannelEventRunnable;
import io.netty.handler.execution.ChannelUpstreamEventRunnable;
import io.netty.handler.execution.DefaultObjectSizeEstimator;
import io.netty.handler.execution.ExecutionHandler;
import io.netty.handler.execution.ObjectSizeEstimator;
import io.netty.util.internal.ConcurrentIdentityHashMap;
import io.netty.util.internal.QueueFactory;
import io.netty.util.internal.SharedResourceMisuseDetector;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryAwareThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final SharedResourceMisuseDetector misuseDetector = new SharedResourceMisuseDetector(MemoryAwareThreadPoolExecutor.class);
    private volatile Settings settings;
    private final ConcurrentMap<Channel, AtomicLong> channelCounters = new ConcurrentIdentityHashMap<Channel, AtomicLong>();
    private final Limiter totalLimiter;

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, 30L, TimeUnit.SECONDS);
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, Executors.defaultThreadFactory());
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, new DefaultObjectSizeEstimator(), threadFactory);
    }

    public MemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, ObjectSizeEstimator objectSizeEstimator, ThreadFactory threadFactory) {
        super(corePoolSize, corePoolSize, keepAliveTime, unit, QueueFactory.createQueue(Runnable.class), threadFactory, new NewThreadRunsPolicy());
        if (objectSizeEstimator == null) {
            throw new NullPointerException("objectSizeEstimator");
        }
        if (maxChannelMemorySize < 0L) {
            throw new IllegalArgumentException("maxChannelMemorySize: " + maxChannelMemorySize);
        }
        if (maxTotalMemorySize < 0L) {
            throw new IllegalArgumentException("maxTotalMemorySize: " + maxTotalMemorySize);
        }
        this.allowCoreThreadTimeOut(true);
        this.settings = new Settings(objectSizeEstimator, maxChannelMemorySize);
        this.totalLimiter = maxTotalMemorySize == 0L ? null : new Limiter(maxTotalMemorySize);
        misuseDetector.increase();
    }

    @Override
    protected void terminated() {
        super.terminated();
        misuseDetector.decrease();
    }

    public ObjectSizeEstimator getObjectSizeEstimator() {
        return this.settings.objectSizeEstimator;
    }

    public void setObjectSizeEstimator(ObjectSizeEstimator objectSizeEstimator) {
        if (objectSizeEstimator == null) {
            throw new NullPointerException("objectSizeEstimator");
        }
        this.settings = new Settings(objectSizeEstimator, this.settings.maxChannelMemorySize);
    }

    public long getMaxChannelMemorySize() {
        return this.settings.maxChannelMemorySize;
    }

    public void setMaxChannelMemorySize(long maxChannelMemorySize) {
        if (maxChannelMemorySize < 0L) {
            throw new IllegalArgumentException("maxChannelMemorySize: " + maxChannelMemorySize);
        }
        if (this.getTaskCount() > 0L) {
            throw new IllegalStateException("can't be changed after a task is executed");
        }
        this.settings = new Settings(this.settings.objectSizeEstimator, maxChannelMemorySize);
    }

    public long getMaxTotalMemorySize() {
        return this.totalLimiter.limit;
    }

    @Deprecated
    public void setMaxTotalMemorySize(long maxTotalMemorySize) {
        if (maxTotalMemorySize < 0L) {
            throw new IllegalArgumentException("maxTotalMemorySize: " + maxTotalMemorySize);
        }
        if (this.getTaskCount() > 0L) {
            throw new IllegalStateException("can't be changed after a task is executed");
        }
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof ChannelDownstreamEventRunnable) {
            throw new RejectedExecutionException("command must be enclosed with an upstream event.");
        }
        if (!(command instanceof ChannelEventRunnable)) {
            command = new MemoryAwareRunnable(command);
        }
        this.increaseCounter(command);
        this.doExecute(command);
    }

    protected void doExecute(Runnable task) {
        this.doUnorderedExecute(task);
    }

    protected final void doUnorderedExecute(Runnable task) {
        super.execute(task);
    }

    @Override
    public boolean remove(Runnable task) {
        boolean removed = super.remove(task);
        if (removed) {
            this.decreaseCounter(task);
        }
        return removed;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.decreaseCounter(r);
    }

    protected void increaseCounter(Runnable task) {
        if (!this.shouldCount(task)) {
            return;
        }
        Settings settings = this.settings;
        long maxChannelMemorySize = settings.maxChannelMemorySize;
        int increment = settings.objectSizeEstimator.estimateSize(task);
        if (task instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventTask = (ChannelEventRunnable)task;
            eventTask.estimatedSize = increment;
            Channel channel = eventTask.getEvent().getChannel();
            long channelCounter = this.getChannelCounter(channel).addAndGet(increment);
            if (maxChannelMemorySize != 0L && channelCounter >= maxChannelMemorySize && channel.isOpen() && channel.isReadable()) {
                ChannelHandlerContext ctx = eventTask.getContext();
                if (ctx.getHandler() instanceof ExecutionHandler) {
                    ctx.setAttachment(Boolean.TRUE);
                }
                channel.setReadable(false);
            }
        } else {
            ((MemoryAwareRunnable)task).estimatedSize = increment;
        }
        if (this.totalLimiter != null) {
            this.totalLimiter.increase(increment);
        }
    }

    protected void decreaseCounter(Runnable task) {
        if (!this.shouldCount(task)) {
            return;
        }
        Settings settings = this.settings;
        long maxChannelMemorySize = settings.maxChannelMemorySize;
        int increment = task instanceof ChannelEventRunnable ? ((ChannelEventRunnable)task).estimatedSize : ((MemoryAwareRunnable)task).estimatedSize;
        if (this.totalLimiter != null) {
            this.totalLimiter.decrease(increment);
        }
        if (task instanceof ChannelEventRunnable) {
            ChannelEventRunnable eventTask = (ChannelEventRunnable)task;
            Channel channel = eventTask.getEvent().getChannel();
            long channelCounter = this.getChannelCounter(channel).addAndGet(-increment);
            if (maxChannelMemorySize != 0L && channelCounter < maxChannelMemorySize && channel.isOpen() && !channel.isReadable()) {
                ChannelHandlerContext ctx = eventTask.getContext();
                if (ctx.getHandler() instanceof ExecutionHandler) {
                    ctx.setAttachment(null);
                }
                channel.setReadable(true);
            }
        }
    }

    private AtomicLong getChannelCounter(Channel channel) {
        AtomicLong oldCounter;
        AtomicLong counter = (AtomicLong)this.channelCounters.get(channel);
        if (counter == null && (oldCounter = this.channelCounters.putIfAbsent(channel, counter = new AtomicLong())) != null) {
            counter = oldCounter;
        }
        if (!channel.isOpen()) {
            this.channelCounters.remove(channel);
        }
        return counter;
    }

    protected boolean shouldCount(Runnable task) {
        if (task instanceof ChannelUpstreamEventRunnable) {
            ChannelUpstreamEventRunnable r = (ChannelUpstreamEventRunnable)task;
            ChannelEvent e = r.getEvent();
            if (e instanceof WriteCompletionEvent) {
                return false;
            }
            if (e instanceof ChannelStateEvent && ((ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS) {
                return false;
            }
        }
        return true;
    }

    private static class Limiter {
        final long limit;
        private long counter;
        private int waiters;

        Limiter(long limit) {
            this.limit = limit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void increase(long amount) {
            while (this.counter >= this.limit) {
                ++this.waiters;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    --this.waiters;
                }
            }
            this.counter += amount;
        }

        synchronized void decrease(long amount) {
            this.counter -= amount;
            if (this.counter < this.limit && this.waiters > 0) {
                this.notifyAll();
            }
        }
    }

    private static final class MemoryAwareRunnable
    implements Runnable {
        final Runnable task;
        int estimatedSize;

        MemoryAwareRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }

    private static final class NewThreadRunsPolicy
    implements RejectedExecutionHandler {
        private NewThreadRunsPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                Thread t = new Thread(r, "Temporary task executor");
                t.start();
            }
            catch (Throwable e) {
                throw new RejectedExecutionException("Failed to start a new thread", e);
            }
        }
    }

    private static final class Settings {
        final ObjectSizeEstimator objectSizeEstimator;
        final long maxChannelMemorySize;

        Settings(ObjectSizeEstimator objectSizeEstimator, long maxChannelMemorySize) {
            this.objectSizeEstimator = objectSizeEstimator;
            this.maxChannelMemorySize = maxChannelMemorySize;
        }
    }
}

