/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class ZNRecordStreamingSerializer
implements ZkSerializer {
    private static Logger LOG = Logger.getLogger(ZNRecordStreamingSerializer.class);

    private static int getListFieldBound(ZNRecord record) {
        int max = Integer.MAX_VALUE;
        if (record.getSimpleFields().containsKey("listField.bound")) {
            String maxStr = record.getSimpleField("listField.bound");
            try {
                max = Integer.parseInt(maxStr);
            }
            catch (Exception e) {
                LOG.error((Object)("IllegalNumberFormat for list field bound: " + maxStr));
            }
        }
        return max;
    }

    public byte[] serialize(Object data) throws ZkMarshallingError {
        if (!(data instanceof ZNRecord)) {
            LOG.error((Object)("Input object must be of type ZNRecord but it is " + data + ". Will not write to zk"));
            throw new HelixException("Input object is not of type ZNRecord (was " + data + ")");
        }
        ZNRecord record = (ZNRecord)data;
        int max = ZNRecordStreamingSerializer.getListFieldBound(record);
        if (max < Integer.MAX_VALUE) {
            Map<String, List<String>> listMap = record.getListFields();
            for (String key : listMap.keySet()) {
                List<String> list = listMap.get(key);
                if (list.size() <= max) continue;
                listMap.put(key, list.subList(0, max));
            }
        }
        StringWriter sw = new StringWriter();
        try {
            JsonFactory f = new JsonFactory();
            JsonGenerator g = f.createJsonGenerator((Writer)sw);
            g.writeStartObject();
            g.writeRaw("\n  ");
            g.writeStringField("id", record.getId());
            g.writeRaw("\n  ");
            g.writeObjectFieldStart("simpleFields");
            for (String key : record.getSimpleFields().keySet()) {
                g.writeRaw("\n    ");
                g.writeStringField(key, record.getSimpleField(key));
            }
            g.writeRaw("\n  ");
            g.writeEndObject();
            g.writeRaw("\n  ");
            g.writeObjectFieldStart("listFields");
            for (String key : record.getListFields().keySet()) {
                g.writeRaw("\n    ");
                g.writeArrayFieldStart(key);
                List<String> list = record.getListField(key);
                for (String listValue : list) {
                    g.writeString(listValue);
                }
                g.writeEndArray();
            }
            g.writeRaw("\n  ");
            g.writeEndObject();
            g.writeRaw("\n  ");
            g.writeObjectFieldStart("mapFields");
            for (String key : record.getMapFields().keySet()) {
                g.writeRaw("\n    ");
                g.writeObjectFieldStart(key);
                Map<String, String> map = record.getMapField(key);
                for (String mapKey : map.keySet()) {
                    g.writeRaw("\n      ");
                    g.writeStringField(mapKey, map.get(mapKey));
                }
                g.writeRaw("\n    ");
                g.writeEndObject();
            }
            g.writeRaw("\n  ");
            g.writeEndObject();
            g.writeRaw("\n");
            g.writeEndObject();
            g.close();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during data serialization. Will not write to zk. Data (first 1k): " + sw.toString().substring(0, 1024)), (Throwable)e);
            throw new HelixException(e);
        }
        if (sw.toString().getBytes().length > 1024000) {
            LOG.error((Object)("Data size larger than 1M, ZNRecord.id: " + record.getId() + ". Will not write to zk. Data (first 1k): " + sw.toString().substring(0, 1024)));
            throw new HelixException("Data size larger than 1M, ZNRecord.id: " + record.getId());
        }
        return sw.toString().getBytes();
    }

    public Object deserialize(byte[] bytes) throws ZkMarshallingError {
        if (bytes == null || bytes.length == 0) {
            LOG.error((Object)"ZNode is empty.");
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ZNRecord record = null;
        try {
            JsonFactory f = new JsonFactory();
            JsonParser jp = f.createJsonParser((InputStream)bais);
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String key;
                String fieldname = jp.getCurrentName();
                jp.nextToken();
                if ("id".equals(fieldname)) {
                    record = new ZNRecord(jp.getText());
                    continue;
                }
                if ("simpleFields".equals(fieldname)) {
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        key = jp.getCurrentName();
                        jp.nextToken();
                        record.setSimpleField(key, jp.getText());
                    }
                    continue;
                }
                if ("mapFields".equals(fieldname)) {
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        key = jp.getCurrentName();
                        record.setMapField(key, new TreeMap<String, String>());
                        jp.nextToken();
                        while (jp.nextToken() != JsonToken.END_OBJECT) {
                            String mapKey = jp.getCurrentName();
                            jp.nextToken();
                            record.getMapField(key).put(mapKey, jp.getText());
                        }
                    }
                    continue;
                }
                if ("listFields".equals(fieldname)) {
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        key = jp.getCurrentName();
                        record.setListField(key, new ArrayList<String>());
                        jp.nextToken();
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            record.getListField(key).add(jp.getText());
                        }
                    }
                    continue;
                }
                throw new IllegalStateException("Unrecognized field '" + fieldname + "'!");
            }
            jp.close();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception during deserialization of bytes: " + new String(bytes)), (Throwable)e);
        }
        return record;
    }

    public static void main(String[] args) {
        ZNRecord record = new ZNRecord("record");
        int recordSize = 10;
        for (int i = 0; i < 10; ++i) {
            int j;
            record.setSimpleField("" + i, "" + i);
            record.setListField("" + i, new ArrayList<String>());
            for (j = 0; j < 10; ++j) {
                record.getListField("" + i).add("" + j);
            }
            record.setMapField("" + i, new TreeMap<String, String>());
            for (j = 0; j < 10; ++j) {
                record.getMapField("" + i).put("" + j, "" + j);
            }
        }
        ZNRecordStreamingSerializer serializer = new ZNRecordStreamingSerializer();
        byte[] bytes = serializer.serialize(record);
        System.out.println(new String(bytes));
        ZNRecord record2 = (ZNRecord)serializer.deserialize(bytes);
        System.out.println(record2);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            bytes = serializer.serialize(record);
            record2 = (ZNRecord)serializer.deserialize(bytes);
        }
        long end = System.currentTimeMillis();
        System.out.println("ZNRecordStreamingSerializer time used: " + (end - start));
        ZNRecordSerializer serializer2 = new ZNRecordSerializer();
        bytes = serializer2.serialize(record);
        record2 = (ZNRecord)serializer2.deserialize(bytes);
        start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            bytes = serializer2.serialize(record);
            record2 = (ZNRecord)serializer2.deserialize(bytes);
        }
        end = System.currentTimeMillis();
        System.out.println("ZNRecordSerializer time used: " + (end - start));
    }
}

