/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.lang.management.ManagementFactory;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitorMBean;
import org.apache.helix.monitoring.mbeans.MessageQueueMonitor;
import org.apache.helix.monitoring.mbeans.ResourceMonitor;
import org.apache.log4j.Logger;

public class ClusterStatusMonitor
implements ClusterStatusMonitorMBean {
    private static final Logger LOG = Logger.getLogger(ClusterStatusMonitor.class);
    static final String CLUSTER_STATUS_KEY = "ClusterStatus";
    static final String MESSAGE_QUEUE_STATUS_KEY = "MessageQueueStatus";
    static final String RESOURCE_STATUS_KEY = "ResourceStatus";
    static final String CLUSTER_DN_KEY = "cluster";
    static final String RESOURCE_DN_KEY = "resourceName";
    static final String INSTANCE_DN_KEY = "instanceName";
    private final String _clusterName;
    private final MBeanServer _beanServer;
    private int _numOfLiveInstances = 0;
    private int _numOfInstances = 0;
    private int _numOfDisabledInstances = 0;
    private int _numOfDisabledPartitions = 0;
    private final ConcurrentHashMap<String, ResourceMonitor> _resourceMbeanMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MessageQueueMonitor> _instanceMsgQueueMbeanMap = new ConcurrentHashMap();

    public ClusterStatusMonitor(String clusterName) {
        this._clusterName = clusterName;
        this._beanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.register(this, this.getObjectName("cluster=" + this._clusterName));
        }
        catch (Exception e) {
            LOG.error((Object)"Register self failed.", (Throwable)e);
        }
    }

    public ObjectName getObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName("ClusterStatus: " + name);
    }

    public String getBeanName() {
        return "ClusterStatus " + this._clusterName;
    }

    @Override
    public long getDownInstanceGauge() {
        return this._numOfInstances - this._numOfLiveInstances;
    }

    @Override
    public long getInstancesGauge() {
        return this._numOfInstances;
    }

    @Override
    public long getDisabledInstancesGauge() {
        return this._numOfDisabledInstances;
    }

    @Override
    public long getDisabledPartitionsGauge() {
        return this._numOfDisabledPartitions;
    }

    @Override
    public long getMaxMessageQueueSizeGauge() {
        long maxQueueSize = 0L;
        for (MessageQueueMonitor msgQueue : this._instanceMsgQueueMbeanMap.values()) {
            if (!(msgQueue.getMaxMessageQueueSize() > (double)maxQueueSize)) continue;
            maxQueueSize = (long)msgQueue.getMaxMessageQueueSize();
        }
        return maxQueueSize;
    }

    @Override
    public String getMessageQueueSizes() {
        TreeMap<String, Long> msgQueueSizes = new TreeMap<String, Long>();
        for (String instance : this._instanceMsgQueueMbeanMap.keySet()) {
            MessageQueueMonitor msgQueue = this._instanceMsgQueueMbeanMap.get(instance);
            msgQueueSizes.put(instance, new Long((long)msgQueue.getMaxMessageQueueSize()));
        }
        return ((Object)msgQueueSizes).toString();
    }

    private void register(Object bean, ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            LOG.info((Object)("Registering " + name.toString()));
            this._beanServer.registerMBean(bean, name);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not register MBean" + name), (Throwable)e);
        }
    }

    private void unregister(ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                LOG.info((Object)("Unregistering " + name.toString()));
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not unregister MBean" + name), (Throwable)e);
        }
    }

    public void setClusterStatusCounters(int numberLiveInstances, int numberOfInstances, int disabledInstances, int disabledPartitions) {
        this._numOfInstances = numberOfInstances;
        this._numOfLiveInstances = numberLiveInstances;
        this._numOfDisabledInstances = disabledInstances;
        this._numOfDisabledPartitions = disabledPartitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExternalViewChange(ExternalView externalView, IdealState idealState) {
        try {
            String resourceName = externalView.getId();
            if (!this._resourceMbeanMap.containsKey(resourceName)) {
                ClusterStatusMonitor clusterStatusMonitor = this;
                synchronized (clusterStatusMonitor) {
                    if (!this._resourceMbeanMap.containsKey(resourceName)) {
                        ResourceMonitor bean = new ResourceMonitor(this._clusterName, resourceName);
                        String beanName = "cluster=" + this._clusterName + "," + RESOURCE_DN_KEY + "=" + resourceName;
                        this.register(bean, this.getObjectName(beanName));
                        this._resourceMbeanMap.put(resourceName, bean);
                    }
                }
            }
            this._resourceMbeanMap.get(resourceName).updateExternalView(externalView, idealState);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageQueueSize(String instanceName, int msgQueueSize) {
        try {
            if (!this._instanceMsgQueueMbeanMap.containsKey(instanceName)) {
                ClusterStatusMonitor clusterStatusMonitor = this;
                synchronized (clusterStatusMonitor) {
                    if (!this._instanceMsgQueueMbeanMap.containsKey(instanceName)) {
                        MessageQueueMonitor bean = new MessageQueueMonitor(this._clusterName, instanceName);
                        this._instanceMsgQueueMbeanMap.put(instanceName, bean);
                    }
                }
            }
            this._instanceMsgQueueMbeanMap.get(instanceName).addMessageQueueSize(msgQueueSize);
        }
        catch (Exception e) {
            LOG.warn((Object)"fail to add message queue size to mbean", (Throwable)e);
        }
    }

    public void reset() {
        LOG.info((Object)"Resetting ClusterStatusMonitor");
        try {
            for (String resourceName : this._resourceMbeanMap.keySet()) {
                String beanName = "cluster=" + this._clusterName + "," + RESOURCE_DN_KEY + "=" + resourceName;
                this.unregister(this.getObjectName(beanName));
            }
            this._resourceMbeanMap.clear();
            for (MessageQueueMonitor bean : this._instanceMsgQueueMbeanMap.values()) {
                bean.reset();
            }
            this._instanceMsgQueueMbeanMap.clear();
            this.unregister(this.getObjectName("cluster=" + this._clusterName));
        }
        catch (Exception e) {
            LOG.error((Object)"fail to reset ClusterStatusMonitor", (Throwable)e);
        }
    }

    @Override
    public String getSensorName() {
        return "ClusterStatus_" + this._clusterName;
    }
}

