/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.helix.manager.zk.ZkClient;

public class ZKDumper {
    private ZkClient client;
    private FilenameFilter filter;
    static Options options = new Options();
    private String suffix = "";
    private boolean removeSuffix = false;

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isRemoveSuffix() {
        return this.removeSuffix;
    }

    public void setRemoveSuffix(boolean removeSuffix) {
        this.removeSuffix = removeSuffix;
    }

    public ZKDumper(String zkAddress) {
        this.client = new ZkClient(zkAddress, 60000);
        ZkSerializer zkSerializer = new ZkSerializer(){

            public byte[] serialize(Object arg0) throws ZkMarshallingError {
                return arg0.toString().getBytes();
            }

            public Object deserialize(byte[] arg0) throws ZkMarshallingError {
                return new String(arg0);
            }
        };
        this.client.setZkSerializer(zkSerializer);
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        };
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java " + ZKDumper.class.getName(), options);
            System.exit(1);
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        cmd.hasOption("zkSvr");
        boolean download = cmd.hasOption("download");
        boolean upload = cmd.hasOption("upload");
        boolean del = cmd.hasOption("delete");
        String zkAddress = cmd.getOptionValue("zkSvr");
        String zkPath = cmd.getOptionValue("zkpath");
        String fsPath = cmd.getOptionValue("fspath");
        ZKDumper zkDump = new ZKDumper(zkAddress);
        if (download) {
            if (cmd.hasOption("addSuffix")) {
                zkDump.suffix = cmd.getOptionValue("addSuffix");
            }
            zkDump.download(zkPath, fsPath + zkPath);
        }
        if (upload) {
            if (cmd.hasOption("removeSuffix")) {
                zkDump.removeSuffix = true;
            }
            zkDump.upload(zkPath, fsPath);
        }
        if (del) {
            zkDump.delete(zkPath);
        }
    }

    private void delete(String zkPath) {
        this.client.deleteRecursive(zkPath);
    }

    public void upload(String zkPath, String fsPath) throws Exception {
        block14: {
            File file;
            block13: {
                file = new File(fsPath);
                System.out.println("Uploading " + file.getCanonicalPath() + " to " + zkPath);
                zkPath = zkPath.replaceAll("[/]+", "/");
                int index = -1;
                if (this.removeSuffix && (index = file.getName().indexOf(".")) > -1) {
                    zkPath = zkPath.replaceAll(file.getName().substring(index), "");
                }
                if (!file.isDirectory()) break block13;
                File[] children = file.listFiles(this.filter);
                this.client.createPersistent(zkPath, true);
                if (children == null || children.length <= 0) break block14;
                for (File child : children) {
                    this.upload(zkPath + "/" + child.getName(), fsPath + "/" + child.getName());
                }
                break block14;
            }
            BufferedReader bfr = null;
            try {
                String line;
                bfr = new BufferedReader(new FileReader(file));
                StringBuilder sb = new StringBuilder();
                String recordDelimiter = "";
                while ((line = bfr.readLine()) != null) {
                    sb.append(recordDelimiter).append(line);
                    recordDelimiter = "\n";
                }
                this.client.createPersistent(zkPath, sb.toString());
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (bfr != null) {
                    try {
                        bfr.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void download(String zkPath, String fsPath) throws Exception {
        List children = this.client.getChildren(zkPath);
        if (children != null && children.size() > 0) {
            new File(fsPath).mkdirs();
            for (String child : children) {
                String childPath = zkPath.equals("/") ? "/" + child : zkPath + "/" + child;
                this.download(childPath, fsPath + "/" + child);
            }
        } else {
            System.out.println("Saving " + zkPath + " to " + new File(fsPath + this.suffix).getCanonicalPath());
            FileWriter fileWriter = new FileWriter(fsPath + this.suffix);
            Object readData = this.client.readData(zkPath);
            if (readData != null) {
                fileWriter.write((String)readData);
            }
            fileWriter.close();
        }
    }

    static {
        OptionGroup optionGroup = new OptionGroup();
        OptionBuilder.withLongOpt((String)"download");
        OptionBuilder.withDescription((String)"Download from ZK to File System");
        Option d = OptionBuilder.create();
        d.setArgs(0);
        OptionBuilder.withLongOpt((String)"addSuffix");
        OptionBuilder.withDescription((String)"add suffix to every file downloaded from ZK");
        Option dSuffix = OptionBuilder.create();
        dSuffix.setArgs(1);
        dSuffix.setRequired(false);
        OptionBuilder.withLongOpt((String)"upload");
        OptionBuilder.withDescription((String)"Upload from File System to ZK");
        Option u = OptionBuilder.create();
        u.setArgs(0);
        OptionBuilder.withLongOpt((String)"removeSuffix");
        OptionBuilder.withDescription((String)"remove suffix from every file uploaded to ZK");
        Option uSuffix = OptionBuilder.create();
        uSuffix.setArgs(0);
        uSuffix.setRequired(false);
        OptionBuilder.withLongOpt((String)"delete");
        OptionBuilder.withDescription((String)"Delete given path from ZK");
        Option del = OptionBuilder.create();
        optionGroup.setRequired(true);
        optionGroup.addOption(del);
        optionGroup.addOption(u);
        optionGroup.addOption(d);
        options.addOptionGroup(optionGroup);
        options.addOption("zkSvr", true, "Zookeeper address");
        options.addOption("zkpath", true, "Zookeeper path");
        options.addOption("fspath", true, "Path on local Filesystem to dump");
        options.addOption("h", "help", false, "Print this usage information");
        options.addOption("v", "verbose", false, "Print out VERBOSE information");
        options.addOption(dSuffix);
        options.addOption(uSuffix);
    }
}

