/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.server.auth.source.AbstractDatabaseAuthSource;

public class JDBCAuthenticationSource
extends AbstractDatabaseAuthSource
implements AuthenticationSource {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCAuthenticationSource.class);
    private String dbDriver;
    private String dbUrl;
    private String dbUserName;
    private String dbPassword;

    @Override
    public void initialize(Map<String, ?> options) {
        try {
            this.dbDriver = (String)options.get("dbDriver");
            this.dbUrl = (String)options.get("dbUrl");
            this.dbUserName = (String)options.get("dbUserName");
            this.dbPassword = (String)options.get("dbPassword");
            if (this.dbUserName == null) {
                this.dbUserName = "";
            }
            if (this.dbPassword == null) {
                this.dbPassword = "";
            }
            if (this.dbDriver != null) {
                Class.forName(this.dbDriver);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.toString(), e);
        }
    }

    @Override
    public Connection getConnection() {
        if (this.dbDriver == null || this.dbUrl == null) {
            throw new IllegalStateException("Database connection information not configured");
        }
        LOG.debug("Connecting using dbDriver=" + this.dbDriver + "+ dbUserName=" + this.dbUserName + ", dbPassword=" + this.dbUrl);
        try {
            return DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e.toString(), e);
        }
    }
}

