/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ChannelBufferFactory;
import io.netty.buffer.HeapChannelBufferFactory;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.util.internal.ConversionUtil;
import java.util.Map;

public class DefaultChannelConfig
implements ChannelConfig {
    private volatile ChannelBufferFactory bufferFactory = HeapChannelBufferFactory.getInstance();
    private volatile int connectTimeoutMillis = 10000;

    @Override
    public void setOptions(Map<String, Object> options) {
        for (Map.Entry<String, Object> e : options.entrySet()) {
            this.setOption(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean setOption(String key, Object value) {
        if (key.equals("pipelineFactory")) {
            this.setPipelineFactory((ChannelPipelineFactory)value);
        } else if (key.equals("connectTimeoutMillis")) {
            this.setConnectTimeoutMillis(ConversionUtil.toInt(value));
        } else if (key.equals("bufferFactory")) {
            this.setBufferFactory((ChannelBufferFactory)value);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public ChannelBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public void setBufferFactory(ChannelBufferFactory bufferFactory) {
        if (bufferFactory == null) {
            throw new NullPointerException("bufferFactory");
        }
        this.bufferFactory = bufferFactory;
    }

    @Override
    public ChannelPipelineFactory getPipelineFactory() {
        return null;
    }

    @Override
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        if (connectTimeoutMillis < 0) {
            throw new IllegalArgumentException("connectTimeoutMillis: " + connectTimeoutMillis);
        }
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @Override
    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
    }
}

