/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.nio.NioWorker;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.SocketChannel;

final class NioClientSocketChannel
extends NioSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketChannel.class);
    volatile ChannelFuture connectFuture;
    volatile boolean boundManually;
    long connectDeadlineNanos;

    private static SocketChannel newSocket() {
        SocketChannel socket;
        try {
            socket = SocketChannel.open();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
        boolean success = false;
        try {
            socket.configureBlocking(false);
            success = true;
        }
        catch (IOException e) {
            throw new ChannelException("Failed to enter non-blocking mode.", e);
        }
        finally {
            block13: {
                if (!success) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        if (!logger.isWarnEnabled()) break block13;
                        logger.warn("Failed to close a partially initialized socket.", e);
                    }
                }
            }
        }
        return socket;
    }

    static NioClientSocketChannel create(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioWorker worker) {
        NioClientSocketChannel instance = new NioClientSocketChannel(factory, pipeline, sink, worker);
        Channels.fireChannelOpen(instance);
        return instance;
    }

    private NioClientSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioWorker worker) {
        super(null, factory, pipeline, sink, NioClientSocketChannel.newSocket(), worker);
    }
}

