/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.file;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.http.file.HttpStaticFileServerPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class HttpStaticFileServer {
    private final int port;

    public HttpStaticFileServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new HttpStaticFileServerPipelineFactory());
        bootstrap.bind(new InetSocketAddress(this.port));
    }

    public static void main(String[] args) {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new HttpStaticFileServer(port).run();
    }
}

